@extends('layouts.modern')

@section('title', 'إدارة الحضور')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">سجل الحضور - {{ $date->format('Y-m-d') }}</h3>
                    <div>
                        <a href="{{ route('hrm.attendance.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> تسجيل حضور
                        </a>
                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#bulkCheckInModal">
                            <i class="fas fa-users"></i> تسجيل حضور جماعي
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <form action="{{ route('hrm.attendance.index') }}" method="GET" class="form-inline">
                                <div class="form-group mx-1">
                                    <label for="date" class="ml-2">التاريخ:</label>
                                    <input type="date" name="date" id="date" class="form-control" value="{{ $date->format('Y-m-d') }}">
                                </div>
                                <div class="form-group mx-1">
                                    <label for="employee_id" class="ml-2">الموظف:</label>
                                    <select name="employee_id" id="employee_id" class="form-control">
                                        <option value="">-- جميع الموظفين --</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->first_name }} {{ $employee->last_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group mx-1">
                                    <label for="status" class="ml-2">الحالة:</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">-- جميع الحالات --</option>
                                        <option value="present" {{ request('status') == 'present' ? 'selected' : '' }}>حاضر</option>
                                        <option value="absent" {{ request('status') == 'absent' ? 'selected' : '' }}>غائب</option>
                                        <option value="late" {{ request('status') == 'late' ? 'selected' : '' }}>متأخر</option>
                                        <option value="half_day" {{ request('status') == 'half_day' ? 'selected' : '' }}>نصف يوم</option>
                                        <option value="on_leave" {{ request('status') == 'on_leave' ? 'selected' : '' }}>في إجازة</option>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary mx-1">تصفية</button>
                                <a href="{{ route('hrm.attendance.index') }}" class="btn btn-secondary">إعادة تعيين</a>
                            </form>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>الموظف</th>
                                    <th>رقم الموظف</th>
                                    <th>القسم</th>
                                    <th>وقت الحضور</th>
                                    <th>وقت الانصراف</th>
                                    <th>إجمالي الساعات</th>
                                    <th>التأخير (دقائق)</th>
                                    <th>الإضافي (دقائق)</th>
                                    <th>الحالة</th>
                                    <th>ملاحظات</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($attendances as $attendance)
                                    <tr>
                                        <td>
                                            <a href="{{ route('hrm.employees.show', $attendance->employee->id) }}">
                                                {{ $attendance->employee->first_name }} {{ $attendance->employee->last_name }}
                                            </a>
                                        </td>
                                        <td>{{ $attendance->employee->employee_number }}</td>
                                        <td>{{ $attendance->employee->department ? $attendance->employee->department->name : '-' }}</td>
                                        <td>{{ $attendance->check_in ? $attendance->check_in->format('H:i') : '-' }}</td>
                                        <td>{{ $attendance->check_out ? $attendance->check_out->format('H:i') : '-' }}</td>
                                        <td>{{ $attendance->total_hours }}</td>
                                        <td>{{ $attendance->late_minutes }}</td>
                                        <td>{{ $attendance->overtime_minutes }}</td>
                                        <td>
                                            @if($attendance->status == 'present')
                                                <span class="badge badge-success">حاضر</span>
                                            @elseif($attendance->status == 'absent')
                                                <span class="badge badge-danger">غائب</span>
                                            @elseif($attendance->status == 'late')
                                                <span class="badge badge-warning">متأخر</span>
                                            @elseif($attendance->status == 'half_day')
                                                <span class="badge badge-info">نصف يوم</span>
                                            @elseif($attendance->status == 'on_leave')
                                                <span class="badge badge-secondary">في إجازة</span>
                                            @endif
                                        </td>
                                        <td>{{ $attendance->notes ?: '-' }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('hrm.attendance.edit', $attendance->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $attendance->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>

                                            <!-- Delete Modal -->
                                            <div class="modal fade" id="deleteModal{{ $attendance->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $attendance->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $attendance->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من رغبتك في حذف سجل حضور الموظف <strong>{{ $attendance->employee->first_name }} {{ $attendance->employee->last_name }}</strong> ليوم {{ $attendance->date->format('Y-m-d') }}؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('hrm.attendance.destroy', $attendance->id) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="11" class="text-center">لا توجد سجلات حضور لهذا اليوم</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- الموظفين بدون تسجيل حضور -->
    @if($employeesWithoutAttendance->count() > 0)
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">الموظفين بدون تسجيل حضور اليوم</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('hrm.attendance.bulk-check-in') }}" method="POST">
                            @csrf
                            <input type="hidden" name="date" value="{{ $date->format('Y-m-d') }}">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th style="width: 30px;">
                                                <div class="icheck-primary">
                                                    <input type="checkbox" id="select-all">
                                                    <label for="select-all"></label>
                                                </div>
                                            </th>
                                            <th>الموظف</th>
                                            <th>رقم الموظف</th>
                                            <th>القسم</th>
                                            <th>المسمى الوظيفي</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($employeesWithoutAttendance as $employee)
                                            <tr>
                                                <td>
                                                    <div class="icheck-primary">
                                                        <input type="checkbox" name="employee_ids[]" id="employee{{ $employee->id }}" value="{{ $employee->id }}">
                                                        <label for="employee{{ $employee->id }}"></label>
                                                    </div>
                                                </td>
                                                <td>{{ $employee->first_name }} {{ $employee->last_name }}</td>
                                                <td>{{ $employee->employee_number }}</td>
                                                <td>{{ $employee->department ? $employee->department->name : '-' }}</td>
                                                <td>{{ $employee->jobTitle ? $employee->jobTitle->name : '-' }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-3">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="bulk_status">الحالة</label>
                                            <select name="status" id="bulk_status" class="form-control" required>
                                                <option value="present">حاضر</option>
                                                <option value="absent">غائب</option>
                                                <option value="late">متأخر</option>
                                                <option value="on_leave">في إجازة</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="bulk_check_in">وقت الحضور</label>
                                            <input type="time" name="check_in" id="bulk_check_in" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="bulk_check_out">وقت الانصراف</label>
                                            <input type="time" name="check_out" id="bulk_check_out" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <button type="submit" class="btn btn-primary btn-block">تسجيل الحضور للمحددين</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

<!-- Bulk Check-In Modal -->
<div class="modal fade" id="bulkCheckInModal" tabindex="-1" role="dialog" aria-labelledby="bulkCheckInModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="bulkCheckInModalLabel">تسجيل حضور جماعي</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="{{ route('hrm.attendance.bulk-check-in') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="modal_date">التاريخ</label>
                        <input type="date" name="date" id="modal_date" class="form-control" value="{{ $date->format('Y-m-d') }}" required>
                    </div>
                    <div class="form-group">
                        <label for="modal_check_in">وقت الحضور</label>
                        <input type="time" name="check_in" id="modal_check_in" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="modal_status">الحالة</label>
                        <select name="status" id="modal_status" class="form-control" required>
                            <option value="present">حاضر</option>
                            <option value="late">متأخر</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>اختر الموظفين</label>
                        <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                            <table class="table table-bordered table-sm">
                                <thead>
                                    <tr>
                                        <th style="width: 30px;">
                                            <div class="icheck-primary">
                                                <input type="checkbox" id="modal-select-all">
                                                <label for="modal-select-all"></label>
                                            </div>
                                        </th>
                                        <th>الموظف</th>
                                        <th>رقم الموظف</th>
                                        <th>القسم</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($employeesWithoutAttendance as $employee)
                                        <tr>
                                            <td>
                                                <div class="icheck-primary">
                                                    <input type="checkbox" name="employee_ids[]" id="modal-employee{{ $employee->id }}" value="{{ $employee->id }}">
                                                    <label for="modal-employee{{ $employee->id }}"></label>
                                                </div>
                                            </td>
                                            <td>{{ $employee->first_name }} {{ $employee->last_name }}</td>
                                            <td>{{ $employee->employee_number }}</td>
                                            <td>{{ $employee->department ? $employee->department->name : '-' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">تسجيل الحضور</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Select all checkboxes
        $('#select-all').change(function() {
            $('input[name="employee_ids[]"]').prop('checked', $(this).prop('checked'));
        });

        // Modal select all
        $('#modal-select-all').change(function() {
            $('#bulkCheckInModal input[name="employee_ids[]"]').prop('checked', $(this).prop('checked'));
        });
    });
</script>
@endpush
@endsection