@extends('layouts.modern')

@section('title', 'تعديل سجل الحضور')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل سجل الحضور - {{ $attendance->employee->first_name }} {{ $attendance->employee->last_name }}</h3>
                </div>
                <form action="{{ route('hrm.attendance.update', $attendance->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 form-group">
                                <label for="employee_id">الموظف</label>
                                <input type="text" class="form-control" value="{{ $attendance->employee->first_name }} {{ $attendance->employee->last_name }} ({{ $attendance->employee->employee_number }})" readonly>
                                <input type="hidden" name="employee_id" value="{{ $attendance->employee_id }}">
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="date">التاريخ <span class="text-danger">*</span></label>
                                <input type="date" name="date" id="date" class="form-control @error('date') is-invalid @enderror" value="{{ old('date', $attendance->date->format('Y-m-d')) }}" required>
                                @error('date')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="status">الحالة <span class="text-danger">*</span></label>
                                <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                    <option value="">-- اختر الحالة --</option>
                                    <option value="present" {{ old('status', $attendance->status) == 'present' ? 'selected' : '' }}>حاضر</option>
                                    <option value="absent" {{ old('status', $attendance->status) == 'absent' ? 'selected' : '' }}>غائب</option>
                                    <option value="late" {{ old('status', $attendance->status) == 'late' ? 'selected' : '' }}>متأخر</option>
                                    <option value="half_day" {{ old('status', $attendance->status) == 'half_day' ? 'selected' : '' }}>نصف يوم</option>
                                    <option value="on_leave" {{ old('status', $attendance->status) == 'on_leave' ? 'selected' : '' }}>في إجازة</option>
                                </select>
                                @error('status')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="check_in">وقت الحضور</label>
                                <input type="time" name="check_in" id="check_in" class="form-control @error('check_in') is-invalid @enderror" value="{{ old('check_in', $attendance->check_in ? $attendance->check_in->format('H:i') : '') }}">
                                @error('check_in')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="check_out">وقت الانصراف</label>
                                <input type="time" name="check_out" id="check_out" class="form-control @error('check_out') is-invalid @enderror" value="{{ old('check_out', $attendance->check_out ? $attendance->check_out->format('H:i') : '') }}">
                                @error('check_out')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="late_minutes">دقائق التأخير</label>
                                <input type="number" name="late_minutes" id="late_minutes" class="form-control @error('late_minutes') is-invalid @enderror" value="{{ old('late_minutes', $attendance->late_minutes) }}" min="0">
                                @error('late_minutes')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-4 form-group">
                                <label for="overtime_minutes">دقائق العمل الإضافي</label>
                                <input type="number" name="overtime_minutes" id="overtime_minutes" class="form-control @error('overtime_minutes') is-invalid @enderror" value="{{ old('overtime_minutes', $attendance->overtime_minutes) }}" min="0">
                                @error('overtime_minutes')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-8 form-group">
                                <label for="notes">ملاحظات</label>
                                <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $attendance->notes) }}</textarea>
                                @error('notes')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                        <a href="{{ route('hrm.attendance.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // تحديث حقول الوقت بناءً على الحالة المختارة
        $('#status').change(function() {
            var status = $(this).val();
            
            if (status === 'absent' || status === 'on_leave') {
                $('#check_in').val('').prop('disabled', true);
                $('#check_out').val('').prop('disabled', true);
                $('#late_minutes').val(0).prop('disabled', true);
                $('#overtime_minutes').val(0).prop('disabled', true);
            } else {
                $('#check_in').prop('disabled', false);
                $('#check_out').prop('disabled', false);
                $('#late_minutes').prop('disabled', false);
                $('#overtime_minutes').prop('disabled', false);
                
                if (status === 'late' && $('#late_minutes').val() == 0) {
                    $('#late_minutes').val(1);
                }
            }
        });
        
        // تشغيل الدالة عند تحميل الصفحة لتطبيق الحالة الأولية
        $('#status').trigger('change');
    });
</script>
@endpush
@endsection