@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>تقرير الربحية</h4>
                    <div>
                        <form action="{{ route('financial-reports.export', 'profitability') }}" method="GET" class="d-inline">
                            <input type="hidden" name="start_date" value="{{ $report['period']['start_date'] }}">
                            <input type="hidden" name="end_date" value="{{ $report['period']['end_date'] }}">
                            <input type="hidden" name="group_by" value="{{ $report['group_by'] }}">
                            <button type="submit" class="btn btn-secondary" target="_blank">
                                <i class="fas fa-file-pdf"></i> تصدير PDF
                            </button>
                        </form>
                        <a href="{{ route('financial-reports.profitability-form') }}" class="btn btn-primary">
                            <i class="fas fa-filter"></i> تغيير الفترة
                        </a>
                        <a href="{{ route('financial-reports.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>معلومات التقرير</h5>
                            <p><strong>الفترة:</strong> {{ $report['period']['start_date'] }} إلى {{ $report['period']['end_date'] }}</p>
                            <p><strong>تجميع حسب:</strong> 
                                @if($report['group_by'] == 'customer')
                                    العميل
                                @elseif($report['group_by'] == 'elevator')
                                    المصعد
                                @elseif($report['group_by'] == 'contract')
                                    العقد
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <h5>ملخص</h5>
                            <p><strong>إجمالي الإيرادات:</strong> {{ number_format($report['summary']['total_revenue'], 2) }}</p>
                            <p><strong>إجمالي التكاليف:</strong> {{ number_format($report['summary']['total_cost'], 2) }}</p>
                            <p><strong>إجمالي الربح:</strong> {{ number_format($report['summary']['total_profit'], 2) }}</p>
                            <p><strong>هامش الربح:</strong> {{ number_format($report['summary']['profit_margin'], 1) }}%</p>
                        </div>
                    </div>

                    <h5 class="mt-4 mb-3">تفاصيل الربحية</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>
                                        @if($report['group_by'] == 'customer')
                                            العميل
                                        @elseif($report['group_by'] == 'elevator')
                                            المصعد
                                        @elseif($report['group_by'] == 'contract')
                                            العقد
                                        @endif
                                    </th>
                                    <th>الإيرادات</th>
                                    <th>التكاليف</th>
                                    <th>الربح</th>
                                    <th>هامش الربح</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($report['items'] as $item)
                                    <tr>
                                        <td>{{ $item['name'] }}</td>
                                        <td>{{ number_format($item['revenue'], 2) }}</td>
                                        <td>{{ number_format($item['cost'], 2) }}</td>
                                        <td>{{ number_format($item['profit'], 2) }}</td>
                                        <td>{{ number_format($item['profit_margin'], 1) }}%</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td><strong>الإجمالي</strong></td>
                                    <td><strong>{{ number_format($report['summary']['total_revenue'], 2) }}</strong></td>
                                    <td><strong>{{ number_format($report['summary']['total_cost'], 2) }}</strong></td>
                                    <td><strong>{{ number_format($report['summary']['total_profit'], 2) }}</strong></td>
                                    <td><strong>{{ number_format($report['summary']['profit_margin'], 1) }}%</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <p><strong>ملاحظة:</strong> يتم حساب هامش الربح بقسمة الربح على الإيرادات وضرب الناتج في 100.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection