<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير الربحية</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin-bottom: 5px;
        }
        .report-info {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .report-info h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .summary {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .summary h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>تقرير الربحية</h1>
        <p>{{ $report['period']['start_date'] }} إلى {{ $report['period']['end_date'] }}</p>
    </div>

    <div class="report-info">
        <h3>معلومات التقرير</h3>
        <p><strong>الفترة:</strong> {{ $report['period']['start_date'] }} إلى {{ $report['period']['end_date'] }}</p>
        <p><strong>تجميع حسب:</strong> 
            @if($report['group_by'] == 'customer')
                العميل
            @elseif($report['group_by'] == 'elevator')
                المصعد
            @elseif($report['group_by'] == 'contract')
                العقد
            @endif
        </p>
    </div>

    <div class="summary">
        <h3>ملخص</h3>
        <p><strong>إجمالي الإيرادات:</strong> {{ number_format($report['summary']['total_revenue'], 2) }}</p>
        <p><strong>إجمالي التكاليف:</strong> {{ number_format($report['summary']['total_cost'], 2) }}</p>
        <p><strong>إجمالي الربح:</strong> {{ number_format($report['summary']['total_profit'], 2) }}</p>
        <p><strong>هامش الربح:</strong> {{ number_format($report['summary']['profit_margin'], 1) }}%</p>
    </div>

    <h3>تفاصيل الربحية</h3>
    <table>
        <thead>
            <tr>
                <th>
                    @if($report['group_by'] == 'customer')
                        العميل
                    @elseif($report['group_by'] == 'elevator')
                        المصعد
                    @elseif($report['group_by'] == 'contract')
                        العقد
                    @endif
                </th>
                <th>الإيرادات</th>
                <th>التكاليف</th>
                <th>الربح</th>
                <th>هامش الربح</th>
            </tr>
        </thead>
        <tbody>
            @foreach($report['items'] as $item)
                <tr>
                    <td>{{ $item['name'] }}</td>
                    <td>{{ number_format($item['revenue'], 2) }}</td>
                    <td>{{ number_format($item['cost'], 2) }}</td>
                    <td>{{ number_format($item['profit'], 2) }}</td>
                    <td>{{ number_format($item['profit_margin'], 1) }}%</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td><strong>الإجمالي</strong></td>
                <td><strong>{{ number_format($report['summary']['total_revenue'], 2) }}</strong></td>
                <td><strong>{{ number_format($report['summary']['total_cost'], 2) }}</strong></td>
                <td><strong>{{ number_format($report['summary']['total_profit'], 2) }}</strong></td>
                <td><strong>{{ number_format($report['summary']['profit_margin'], 1) }}%</strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>تم إنشاء هذا التقرير بواسطة نظام إدارة المصاعد - {{ date('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>