<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقرير الإيرادات والمصروفات</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            direction: rtl;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin-bottom: 5px;
        }
        .report-info {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .report-info h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        .summary {
            margin-bottom: 30px;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .summary h3 {
            margin-top: 0;
            border-bottom: 1px solid #ddd;
            padding-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>تقرير الإيرادات والمصروفات</h1>
        <p>{{ $report['period']['start_date'] }} إلى {{ $report['period']['end_date'] }}</p>
    </div>

    <div class="report-info">
        <h3>معلومات التقرير</h3>
        <p><strong>الفترة:</strong> {{ $report['period']['start_date'] }} إلى {{ $report['period']['end_date'] }}</p>
        <p><strong>تجميع حسب:</strong> 
            @if($report['group_by'] == 'month')
                شهر
            @elseif($report['group_by'] == 'quarter')
                ربع سنة
            @elseif($report['group_by'] == 'year')
                سنة
            @endif
        </p>
    </div>

    <div class="summary">
        <h3>ملخص</h3>
        <p><strong>إجمالي الإيرادات:</strong> {{ number_format($report['summary']['total_income'], 2) }}</p>
        <p><strong>إجمالي المصروفات:</strong> {{ number_format($report['summary']['total_expenses'], 2) }}</p>
        <p><strong>صافي الدخل:</strong> {{ number_format($report['summary']['net_income'], 2) }}</p>
    </div>

    <h3>الإيرادات والمصروفات حسب الفترة</h3>
    <table>
        <thead>
            <tr>
                <th>الفترة</th>
                <th>الإيرادات</th>
                <th>المصروفات</th>
                <th>صافي الدخل</th>
            </tr>
        </thead>
        <tbody>
            @foreach($report['periods'] as $period)
                <tr>
                    <td>{{ $period['name'] }}</td>
                    <td>{{ number_format($period['income'], 2) }}</td>
                    <td>{{ number_format($period['expenses'], 2) }}</td>
                    <td>{{ number_format($period['net_income'], 2) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td><strong>الإجمالي</strong></td>
                <td><strong>{{ number_format($report['summary']['total_income'], 2) }}</strong></td>
                <td><strong>{{ number_format($report['summary']['total_expenses'], 2) }}</strong></td>
                <td><strong>{{ number_format($report['summary']['net_income'], 2) }}</strong></td>
            </tr>
        </tfoot>
    </table>

    <div style="page-break-before: always;"></div>

    <h3>تفاصيل الإيرادات</h3>
    <table>
        <thead>
            <tr>
                <th>المصدر</th>
                <th>المبلغ</th>
                <th>النسبة</th>
            </tr>
        </thead>
        <tbody>
            @foreach($report['income_details'] as $source => $amount)
                <tr>
                    <td>{{ $source }}</td>
                    <td>{{ number_format($amount, 2) }}</td>
                    <td>{{ number_format(($amount / $report['summary']['total_income']) * 100, 1) }}%</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td><strong>الإجمالي</strong></td>
                <td><strong>{{ number_format($report['summary']['total_income'], 2) }}</strong></td>
                <td><strong>100%</strong></td>
            </tr>
        </tfoot>
    </table>

    <h3>تفاصيل المصروفات</h3>
    <table>
        <thead>
            <tr>
                <th>الفئة</th>
                <th>المبلغ</th>
                <th>النسبة</th>
            </tr>
        </thead>
        <tbody>
            @foreach($report['expense_details'] as $category => $amount)
                <tr>
                    <td>{{ $category }}</td>
                    <td>{{ number_format($amount, 2) }}</td>
                    <td>{{ number_format(($amount / $report['summary']['total_expenses']) * 100, 1) }}%</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td><strong>الإجمالي</strong></td>
                <td><strong>{{ number_format($report['summary']['total_expenses'], 2) }}</strong></td>
                <td><strong>100%</strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>تم إنشاء هذا التقرير بواسطة نظام إدارة المصاعد - {{ date('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html>