@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4>التقارير المالية</h4>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">تقرير الإيرادات والمصروفات</h5>
                                    <p class="card-text">عرض تقرير مفصل للإيرادات والمصروفات خلال فترة زمنية محددة.</p>
                                    <a href="{{ route('financial-reports.income-expense-form') }}" class="btn btn-primary">إنشاء التقرير</a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">تقرير الربحية</h5>
                                    <p class="card-text">تحليل الربحية حسب العملاء أو المصاعد أو العقود.</p>
                                    <a href="{{ route('financial-reports.profitability-form') }}" class="btn btn-primary">إنشاء التقرير</a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">تقارير الضرائب</h5>
                                    <p class="card-text">إنشاء وإدارة تقارير ضريبة القيمة المضافة.</p>
                                    <a href="{{ route('tax-reports.index') }}" class="btn btn-primary">عرض التقارير</a>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-4">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">كشوف حساب العملاء</h5>
                                    <p class="card-text">إنشاء كشوف حساب مفصلة للعملاء.</p>
                                    <a href="{{ route('customer-statements.index') }}" class="btn btn-primary">عرض الكشوف</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection