@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>تقرير الإيرادات والمصروفات</h4>
                    <div>
                        <a href="{{ route('financial-reports.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <form action="{{ route('financial-reports.income-expense') }}" method="POST">
                        @csrf
                        
                        <div class="form-group mb-3">
                            <label for="start_date">تاريخ بداية الفترة</label>
                            <input type="date" name="start_date" id="start_date" class="form-control @error('start_date') is-invalid @enderror" value="{{ old('start_date', now()->startOfMonth()->format('Y-m-d')) }}" required>
                            @error('start_date')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="end_date">تاريخ نهاية الفترة</label>
                            <input type="date" name="end_date" id="end_date" class="form-control @error('end_date') is-invalid @enderror" value="{{ old('end_date', now()->endOfMonth()->format('Y-m-d')) }}" required>
                            @error('end_date')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="group_by">تجميع حسب</label>
                            <select name="group_by" id="group_by" class="form-control @error('group_by') is-invalid @enderror">
                                <option value="month" {{ old('group_by') == 'month' ? 'selected' : '' }}>شهر</option>
                                <option value="quarter" {{ old('group_by') == 'quarter' ? 'selected' : '' }}>ربع سنة</option>
                                <option value="year" {{ old('group_by') == 'year' ? 'selected' : '' }}>سنة</option>
                            </select>
                            @error('group_by')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">إنشاء التقرير</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection