@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>تقرير الإيرادات والمصروفات</h4>
                    <div>
                        <form action="{{ route('financial-reports.export', 'income-expense') }}" method="GET" class="d-inline">
                            <input type="hidden" name="start_date" value="{{ $report['period']['start_date'] }}">
                            <input type="hidden" name="end_date" value="{{ $report['period']['end_date'] }}">
                            <input type="hidden" name="group_by" value="{{ $report['group_by'] ?? 'month' }}">
                            <button type="submit" class="btn btn-secondary" target="_blank">
                                <i class="fas fa-file-pdf"></i> تصدير PDF
                            </button>
                        </form>
                        <a href="{{ route('financial-reports.income-expense-form') }}" class="btn btn-primary">
                            <i class="fas fa-filter"></i> تغيير الفترة
                        </a>
                        <a href="{{ route('financial-reports.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>معلومات التقرير</h5>
                            <p><strong>الفترة:</strong> {{ $report['period']['start_date'] }} إلى {{ $report['period']['end_date'] }}</p>
                            <p><strong>تجميع حسب:</strong> 
                                @if($report['group_by'] == 'month')
                                    شهر
                                @elseif($report['group_by'] == 'quarter')
                                    ربع سنة
                                @elseif($report['group_by'] == 'year')
                                    سنة
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <h5>ملخص</h5>
                            <p><strong>إجمالي الإيرادات:</strong> {{ number_format($report['summary']['total_income'], 2) }}</p>
                            <p><strong>إجمالي المصروفات:</strong> {{ number_format($report['summary']['total_expenses'], 2) }}</p>
                            <p><strong>صافي الدخل:</strong> {{ number_format($report['summary']['net_income'], 2) }}</p>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-12">
                            <h5>الإيرادات والمصروفات حسب الفترة</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>الفترة</th>
                                            <th>الإيرادات</th>
                                            <th>المصروفات</th>
                                            <th>صافي الدخل</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($report['periods'] as $period)
                                            <tr>
                                                <td>{{ $period['name'] }}</td>
                                                <td>{{ number_format($period['income'], 2) }}</td>
                                                <td>{{ number_format($period['expenses'], 2) }}</td>
                                                <td>{{ number_format($period['net_income'], 2) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td><strong>الإجمالي</strong></td>
                                            <td><strong>{{ number_format($report['summary']['total_income'], 2) }}</strong></td>
                                            <td><strong>{{ number_format($report['summary']['total_expenses'], 2) }}</strong></td>
                                            <td><strong>{{ number_format($report['summary']['net_income'], 2) }}</strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>تفاصيل الإيرادات</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>المصدر</th>
                                            <th>المبلغ</th>
                                            <th>النسبة</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($report['income_details'] as $source => $amount)
                                            <tr>
                                                <td>{{ $source }}</td>
                                                <td>{{ number_format($amount, 2) }}</td>
                                                <td>{{ number_format(($amount / $report['summary']['total_income']) * 100, 1) }}%</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td><strong>الإجمالي</strong></td>
                                            <td><strong>{{ number_format($report['summary']['total_income'], 2) }}</strong></td>
                                            <td><strong>100%</strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5>تفاصيل المصروفات</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>الفئة</th>
                                            <th>المبلغ</th>
                                            <th>النسبة</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($report['expense_details'] as $category => $amount)
                                            <tr>
                                                <td>{{ $category }}</td>
                                                <td>{{ number_format($amount, 2) }}</td>
                                                <td>{{ number_format(($amount / $report['summary']['total_expenses']) * 100, 1) }}%</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td><strong>الإجمالي</strong></td>
                                            <td><strong>{{ number_format($report['summary']['total_expenses'], 2) }}</strong></td>
                                            <td><strong>100%</strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection