<!DOCTYPE html>
<html dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title }}</title>
    <style>
        body {
            font-family: 'XB Riyaz', 'Traditional Arabic', Arial, sans-serif;
            direction: rtl;
            text-align: right;
            margin: 0;
            padding: 20px;
            font-size: 14px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin-bottom: 5px;
            color: #333;
        }
        .company-info {
            margin-bottom: 20px;
            text-align: center;
        }
        .report-info {
            margin-bottom: 20px;
            border: 1px solid #ddd;
            padding: 10px;
            background-color: #f9f9f9;
        }
        .report-info p {
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .summary {
            margin-top: 20px;
            border-top: 2px solid #333;
            padding-top: 10px;
        }
        .summary-item {
            display: inline-block;
            margin-left: 20px;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .badge {
            display: inline-block;
            padding: 3px 7px;
            border-radius: 3px;
            font-size: 12px;
            font-weight: bold;
        }
        .badge-info {
            background-color: #17a2b8;
            color: white;
        }
        .badge-warning {
            background-color: #ffc107;
            color: #212529;
        }
        .badge-danger {
            background-color: #dc3545;
            color: white;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>تاريخ التقرير: {{ $date }}</p>
    </div>

    <div class="company-info">
        <h3>{{ $company->name }}</h3>
        <p>{{ $company->address }}</p>
        <p>هاتف: {{ $company->phone }}</p>
        <p>البريد الإلكتروني: {{ $company->email }}</p>
    </div>

    <div class="report-info">
        <p><strong>إجمالي عدد الأقساط المستحقة قريباً:</strong> {{ $total_count }}</p>
        <p><strong>إجمالي المبالغ المستحقة:</strong> {{ number_format($total_amount, 2) }}</p>
        <p><strong>عدد الأقساط المستحقة خلال 7 أيام:</strong> {{ $next_week_count }}</p>
        <p><strong>إجمالي المبالغ المستحقة خلال 7 أيام:</strong> {{ number_format($next_week_amount, 2) }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>رقم الفاتورة</th>
                <th>العميل</th>
                <th>تاريخ الاستحقاق</th>
                <th>الأيام المتبقية</th>
                <th>المبلغ</th>
            </tr>
        </thead>
        <tbody>
            @forelse($installments as $installment)
                <tr>
                    <td>{{ $installment->id }}</td>
                    <td>{{ $installment->invoice->invoice_number }}</td>
                    <td>{{ $installment->invoice->customer->name }}</td>
                    <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                    <td>
                        @php
                            $daysRemaining = $installment->due_date->diffInDays(now());
                            $badgeClass = $daysRemaining <= 3 ? 'badge-danger' : ($daysRemaining <= 7 ? 'badge-warning' : 'badge-info');
                        @endphp
                        <span class="badge {{ $badgeClass }}">
                            {{ $daysRemaining }} يوم
                        </span>
                    </td>
                    <td>{{ number_format($installment->amount, 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" style="text-align: center;">لا توجد أقساط مستحقة قريباً</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="summary">
        <div class="summary-item">إجمالي المبالغ المستحقة: {{ number_format($total_amount, 2) }}</div>
        <div class="summary-item">المبالغ المستحقة خلال 7 أيام: {{ number_format($next_week_amount, 2) }}</div>
    </div>

    <div class="footer">
        <p>تم إنشاء هذا التقرير بواسطة نظام إدارة المصاعد - {{ date('Y-m-d H:i:s') }}</p>
        <p>© {{ date('Y') }} {{ $company->name }} - جميع الحقوق محفوظة</p>
    </div>
</body>
</html>