<!DOCTYPE html>
<html dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title }}</title>
    <style>
        body {
            font-family: 'XB Riyaz', 'Traditional Arabic', Arial, sans-serif;
            direction: rtl;
            text-align: right;
            margin: 0;
            padding: 20px;
            font-size: 14px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin-bottom: 5px;
            color: #333;
        }
        .company-info {
            margin-bottom: 20px;
            text-align: center;
        }
        .report-info {
            margin-bottom: 20px;
            border: 1px solid #ddd;
            padding: 10px;
            background-color: #f9f9f9;
        }
        .report-info p {
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .summary {
            margin-top: 20px;
            border-top: 2px solid #333;
            padding-top: 10px;
        }
        .summary-item {
            display: inline-block;
            margin-left: 20px;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .text-danger {
            color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
        <p>تاريخ التقرير: {{ $date }}</p>
    </div>

    <div class="company-info">
        <h3>{{ $company->name }}</h3>
        <p>{{ $company->address }}</p>
        <p>هاتف: {{ $company->phone }}</p>
        <p>البريد الإلكتروني: {{ $company->email }}</p>
    </div>

    <div class="report-info">
        <p><strong>إجمالي عدد الأقساط المتأخرة:</strong> {{ $installments->count() }}</p>
        <p><strong>إجمالي المبالغ المتأخرة:</strong> {{ number_format($total_amount, 2) }}</p>
        <p><strong>إجمالي المبالغ المدفوعة:</strong> {{ number_format($total_paid, 2) }}</p>
        <p><strong>إجمالي المبالغ المتبقية:</strong> {{ number_format($total_remaining, 2) }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>رقم الفاتورة</th>
                <th>العميل</th>
                <th>تاريخ الاستحقاق</th>
                <th>أيام التأخير</th>
                <th>المبلغ الكلي</th>
                <th>المبلغ المدفوع</th>
                <th>المبلغ المتبقي</th>
            </tr>
        </thead>
        <tbody>
            @forelse($installments as $installment)
                <tr>
                    <td>{{ $installment->id }}</td>
                    <td>{{ $installment->invoice->invoice_number }}</td>
                    <td>{{ $installment->invoice->customer->name }}</td>
                    <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                    <td class="text-danger">{{ now()->diffInDays($installment->due_date) }} يوم</td>
                    <td>{{ number_format($installment->amount, 2) }}</td>
                    <td>{{ number_format($installment->paid_amount, 2) }}</td>
                    <td>{{ number_format($installment->amount - $installment->paid_amount, 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" style="text-align: center;">لا توجد أقساط متأخرة</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="summary">
        <div class="summary-item">إجمالي المبالغ المتأخرة: {{ number_format($total_amount, 2) }}</div>
        <div class="summary-item">إجمالي المبالغ المتبقية: {{ number_format($total_remaining, 2) }}</div>
    </div>

    <div class="footer">
        <p>تم إنشاء هذا التقرير بواسطة نظام إدارة المصاعد - {{ date('Y-m-d H:i:s') }}</p>
        <p>© {{ date('Y') }} {{ $company->name }} - جميع الحقوق محفوظة</p>
    </div>
</body>
</html>