<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>التقرير المالي للصيانة</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            direction: rtl;
            text-align: right;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin-bottom: 5px;
        }
        .header p {
            margin-top: 0;
            color: #666;
        }
        .summary {
            margin-bottom: 30px;
        }
        .summary-box {
            display: inline-block;
            width: 23%;
            margin-right: 1%;
            padding: 10px;
            box-sizing: border-box;
            border: 1px solid #ddd;
            border-radius: 5px;
            text-align: center;
            margin-bottom: 10px;
        }
        .summary-box h3 {
            margin-top: 0;
            margin-bottom: 5px;
        }
        .summary-box p {
            margin-top: 0;
            font-weight: bold;
            font-size: 18px;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: right;
        }
        .table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #666;
        }
        .status-paid {
            color: green;
            font-weight: bold;
        }
        .status-partially-paid {
            color: orange;
            font-weight: bold;
        }
        .status-unpaid {
            color: red;
            font-weight: bold;
        }
        .page-break {
            page-break-after: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>التقرير المالي للصيانة</h1>
        <p>الفترة من {{ $startDate->format('Y-m-d') }} إلى {{ $endDate->format('Y-m-d') }}</p>
    </div>
    
    <div class="summary">
        <div class="summary-box">
            <h3>إجمالي الإيرادات</h3>
            <p>{{ number_format($report['total_revenue']) }} ر.س</p>
        </div>
        <div class="summary-box">
            <h3>الصيانة المكتملة</h3>
            <p>{{ $report['completed_maintenance_count'] }}</p>
        </div>
        <div class="summary-box">
            <h3>الصيانة المعلقة</h3>
            <p>{{ $report['pending_maintenance_count'] }}</p>
        </div>
        <div class="summary-box">
            <h3>الصيانة الفاشلة</h3>
            <p>{{ $report['failed_maintenance_count'] }}</p>
        </div>
    </div>
    
    <h2>فواتير الصيانة</h2>
    <table class="table">
        <thead>
            <tr>
                <th>رقم الفاتورة</th>
                <th>العميل</th>
                <th>المصعد</th>
                <th>تاريخ الفاتورة</th>
                <th>المبلغ</th>
                <th>الحالة</th>
            </tr>
        </thead>
        <tbody>
            @forelse($report['invoices'] as $invoice)
                <tr>
                    <td>{{ $invoice->invoice_number }}</td>
                    <td>{{ $invoice->customer->name ?? 'غير محدد' }}</td>
                    <td>{{ $invoice->elevator->name ?? 'غير محدد' }}</td>
                    <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                    <td>{{ number_format($invoice->total_amount) }} ر.س</td>
                    <td class="status-{{ $invoice->status }}">
                        @if($invoice->status == 'paid')
                            مدفوعة
                        @elseif($invoice->status == 'partially_paid')
                            مدفوعة جزئياً
                        @elseif($invoice->status == 'unpaid')
                            غير مدفوعة
                        @else
                            {{ $invoice->status }}
                        @endif
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" style="text-align: center;">لا توجد فواتير في الفترة المحددة</td>
                </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="page-break"></div>
    
    <h2>الإيرادات حسب العقد</h2>
    <table class="table">
        <thead>
            <tr>
                <th>اسم العقد</th>
                <th>الإيرادات</th>
            </tr>
        </thead>
        <tbody>
            @forelse($report['revenue_by_contract'] as $contract)
                <tr>
                    <td>{{ $contract->contract_name ?? 'بدون عقد' }}</td>
                    <td>{{ number_format($contract->total_revenue) }} ر.س</td>
                </tr>
            @empty
                <tr>
                    <td colspan="2" style="text-align: center;">لا توجد بيانات إيرادات في الفترة المحددة</td>
                </tr>
            @endforelse
        </tbody>
    </table>
    
    <div class="footer">
        <p>تم إنشاء هذا التقرير بتاريخ {{ now()->format('Y-m-d H:i') }}</p>
    </div>
</body>
</html>