@extends('layouts.app')

@section('title', 'المشروع غير موجود')

@section('content')
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>خطأ 404 - المشروع غير موجود</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                        <li class="breadcrumb-item active">خطأ</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="error-page">
            <h2 class="headline text-warning">404</h2>
            <div class="error-content">
                <h3><i class="fas fa-exclamation-triangle text-warning"></i> عذراً! المشروع المطلوب غير موجود.</h3>
                <p>
                    لم نتمكن من العثور على المشروع الذي تبحث عنه.
                    يمكنك <a href="{{ route('installation-projects.index') }}">العودة إلى قائمة المشاريع</a> أو استخدام نموذج البحث.
                </p>
                <p>
                    أسباب محتملة للخطأ:
                </p>
                <ul>
                    <li>المشروع المطلوب غير موجود أو تم حذفه</li>
                    <li>معرف المشروع غير صحيح</li>
                    <li>ليس لديك صلاحية للوصول إلى هذا المشروع</li>
                </ul>
                <p>
                    إذا كنت تعتقد أن هذا خطأ، يرجى الاتصال بمسؤول النظام.
                </p>
                <div class="mt-3">
                    <a href="{{ route('installation-projects.index') }}" class="btn btn-primary">
                        <i class="fas fa-list"></i> عرض جميع المشاريع
                    </a>
                    <a href="{{ route('dashboard') }}" class="btn btn-secondary">
                        <i class="fas fa-home"></i> العودة إلى الرئيسية
                    </a>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection