<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Low Stock Alert</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            border-bottom: 3px solid #dc3545;
        }
        .content {
            padding: 20px;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #6c757d;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #dee2e6;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007bff;
            color: #fff;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 20px;
        }
        .alert {
            padding: 15px;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 4px;
            color: #721c24;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Low Stock Alert</h1>
            <p>Inventory items requiring attention</p>
        </div>
        
        <div class="content">
            <div class="alert">
                <strong>Action Required:</strong> The following items have fallen below the {{ $alert->low_stock_threshold }}% threshold of their minimum stock level.
            </div>
            
            <p>Please review the following items and take appropriate action to replenish stock:</p>
            
            <table>
                <thead>
                    <tr>
                        <th>Item</th>
                        <th>SKU</th>
                        <th>Current Stock</th>
                        <th>Min. Required</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($items as $item)
                    <tr>
                        <td>{{ $item->name }}</td>
                        <td>{{ $item->sku }}</td>
                        <td>{{ $item->available_stock }}</td>
                        <td>{{ $item->min_stock_level }}</td>
                        <td>
                            @php
                                $percentage = ($item->available_stock / $item->min_stock_level) * 100;
                            @endphp
                            @if($percentage <= 5)
                                <strong style="color: #dc3545;">Critical</strong>
                            @elseif($percentage <= 25)
                                <strong style="color: #fd7e14;">Low</strong>
                            @else
                                <span style="color: #ffc107;">Warning</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            
            <p>Please consider creating purchase orders for these items to maintain adequate inventory levels.</p>
            
            <a href="{{ route('inventory.alerts.low-stock') }}" class="btn">View Low Stock Items</a>
        </div>
        
        <div class="footer">
            <p>This is an automated message from your inventory management system.</p>
            <p>© {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>