<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Inventory Expiry Alert</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            border-bottom: 3px solid #fd7e14;
        }
        .content {
            padding: 20px;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            font-size: 12px;
            color: #6c757d;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #dee2e6;
            text-align: left;
        }
        th {
            background-color: #f8f9fa;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background-color: #007bff;
            color: #fff;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 20px;
        }
        .alert {
            padding: 15px;
            background-color: #fff3cd;
            border: 1px solid #ffeeba;
            border-radius: 4px;
            color: #856404;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Inventory Expiry Alert</h1>
            <p>Items expiring within {{ $alert->expiry_threshold_days }} days</p>
        </div>
        
        <div class="content">
            <div class="alert">
                <strong>Action Required:</strong> The following inventory batches will expire soon and require your attention.
            </div>
            
            <p>Please review the following batches and take appropriate action:</p>
            
            <table>
                <thead>
                    <tr>
                        <th>Item</th>
                        <th>Batch Number</th>
                        <th>Expiry Date</th>
                        <th>Days Left</th>
                        <th>Quantity</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($batches as $batch)
                    <tr>
                        <td>{{ $batch->item->name }}</td>
                        <td>{{ $batch->batch_number }}</td>
                        <td>{{ $batch->expiry_date->format('Y-m-d') }}</td>
                        <td>
                            @php
                                $daysRemaining = now()->diffInDays($batch->expiry_date);
                            @endphp
                            @if($daysRemaining <= 7)
                                <strong style="color: #dc3545;">{{ $daysRemaining }} days</strong>
                            @elseif($daysRemaining <= 14)
                                <strong style="color: #fd7e14;">{{ $daysRemaining }} days</strong>
                            @else
                                <span style="color: #ffc107;">{{ $daysRemaining }} days</span>
                            @endif
                        </td>
                        <td>{{ $batch->quantity }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            
            <p>Consider the following actions for expiring items:</p>
            <ul>
                <li>Use these items first in production or sales</li>
                <li>Offer discounts for items approaching expiry</li>
                <li>Check if items can be returned to suppliers</li>
                <li>Plan for proper disposal if necessary</li>
            </ul>
            
            <a href="{{ route('inventory.alerts.expiry') }}" class="btn">View Expiring Items</a>
        </div>
        
        <div class="footer">
            <p>This is an automated message from your inventory management system.</p>
            <p>© {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>