@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('تفاصيل المصعد') }}</span>
                    <div>
                        <a href="{{ route('elevators.edit', $elevator->id) }}" class="btn btn-primary btn-sm mx-1">
                            <i class="fas fa-edit"></i> {{ __('تعديل') }}
                        </a>
                        <a href="{{ route('elevators.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> {{ __('العودة إلى قائمة المصاعد') }}
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row">
                        <div class="col-md-12 mb-4">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">{{ __('معلومات المصعد الأساسية') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <strong>{{ __('الرقم التسلسلي:') }}</strong>
                                            <p>{{ $elevator->serial_number }}</p>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <strong>{{ __('الموديل:') }}</strong>
                                            <p>{{ $elevator->model }}</p>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <strong>{{ __('الشركة المصنعة:') }}</strong>
                                            <p>{{ $elevator->manufacturer }}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4 mb-3">
                                            <strong>{{ __('نوع المصعد:') }}</strong>
                                            <p>{{ $elevatorTypes[$elevator->type] ?? $elevator->type }}</p>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <strong>{{ __('حالة المصعد:') }}</strong>
                                            <p>
                                                @if($elevator->status == 'operational')
                                                    <span class="badge bg-success">يعمل</span>
                                                @elseif($elevator->status == 'maintenance')
                                                    <span class="badge bg-warning">تحت الصيانة</span>
                                                @elseif($elevator->status == 'out_of_service')
                                                    <span class="badge bg-danger">خارج الخدمة</span>
                                                @elseif($elevator->status == 'installation')
                                                    <span class="badge bg-info">قيد التركيب</span>
                                                @endif
                                            </p>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <strong>{{ __('تاريخ التركيب:') }}</strong>
                                            <p>{{ $elevator->installation_date ? $elevator->installation_date->format('Y-m-d') : 'غير محدد' }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">{{ __('معلومات العميل والموقع') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>{{ __('العميل:') }}</strong>
                                        <p>{{ $elevator->customer ? $elevator->customer->name : 'غير محدد' }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('الموقع:') }}</strong>
                                        <p>{{ $elevator->location ? $elevator->location->name : 'غير محدد' }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('العنوان:') }}</strong>
                                        <p>{{ $elevator->location ? $elevator->location->address : 'غير محدد' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">{{ __('المواصفات الفنية') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <strong>{{ __('السعة:') }}</strong>
                                            <p>{{ $elevator->capacity }} {{ __('كجم') }}</p>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <strong>{{ __('عدد الطوابق:') }}</strong>
                                            <p>{{ $elevator->floors_count }} {{ __('طابق') }}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <strong>{{ __('السرعة:') }}</strong>
                                            <p>{{ $elevator->speed }} {{ __('م/ث') }}</p>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <strong>{{ __('تاريخ انتهاء الضمان:') }}</strong>
                                            <p>
                                                @if($elevator->warranty_end_date)
                                                    {{ $elevator->warranty_end_date->format('Y-m-d') }}
                                                    @if($elevator->isUnderWarranty())
                                                        <span class="badge bg-success">{{ __('ساري') }}</span>
                                                    @else
                                                        <span class="badge bg-danger">{{ __('منتهي') }}</span>
                                                    @endif
                                                @else
                                                    {{ __('غير محدد') }}
                                                @endif
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="card">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="mb-0">{{ __('معلومات إضافية') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>{{ __('المواصفات الفنية:') }}</strong>
                                        <p>{{ $elevator->specifications ?: 'لا توجد مواصفات إضافية' }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('ملاحظات:') }}</strong>
                                        <p>{{ $elevator->notes ?: 'لا توجد ملاحظات' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if($elevator->maintenanceContracts->count() > 0)
                        <div class="col-md-12 mb-4">
                            <div class="card">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">{{ __('عقود الصيانة') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>{{ __('رقم العقد') }}</th>
                                                    <th>{{ __('تاريخ البداية') }}</th>
                                                    <th>{{ __('تاريخ الانتهاء') }}</th>
                                                    <th>{{ __('نوع العقد') }}</th>
                                                    <th>{{ __('الحالة') }}</th>
                                                    <th>{{ __('الإجراءات') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($elevator->maintenanceContracts as $index => $contract)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $contract->contract_number }}</td>
                                                        <td>{{ $contract->start_date ? $contract->start_date->format('Y-m-d') : 'غير محدد' }}</td>
                                                        <td>{{ $contract->end_date ? $contract->end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                                        <td>{{ $contract->type }}</td>
                                                        <td>
                                                            @if($contract->status == 'active')
                                                                <span class="badge bg-success">نشط</span>
                                                            @elseif($contract->status == 'expired')
                                                                <span class="badge bg-danger">منتهي</span>
                                                            @elseif($contract->status == 'pending')
                                                                <span class="badge bg-warning">معلق</span>
                                                            @elseif($contract->status == 'cancelled')
                                                                <span class="badge bg-secondary">ملغي</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <a href="{{ route('maintenance-contracts.show', $contract->id) }}" class="btn btn-info btn-sm">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection