@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('قائمة المصاعد') }}</span>
                    <div>
                        <div class="dropdown d-inline-block me-2">
                            <button class="btn btn-info btn-sm dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-download"></i> {{ __('تحميل نموذج الاستيراد') }}
                            </button>
                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <li><a class="dropdown-item" href="{{ asset('templates/elevators_import_template.csv') }}">{{ __('تحميل نموذج CSV') }}</a></li>
                                <li><a class="dropdown-item" href="{{ route('elevators.import.template.excel') }}">{{ __('تحميل نموذج Excel') }}</a></li>
                            </ul>
                        </div>
                        <a href="{{ route('elevators.import.form') }}" class="btn btn-success btn-sm me-2">
                            <i class="fas fa-file-import"></i> {{ __('استيراد من Excel') }}
                        </a>
                        <a href="{{ route('elevators.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> {{ __('إضافة مصعد جديد') }}
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <form action="{{ route('elevators.index') }}" method="GET" class="d-flex">
                                <input type="text" name="search" class="form-control me-2" placeholder="{{ __('بحث بالرقم التسلسلي أو اسم العميل...') }}" value="{{ $search ?? '' }}">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> {{ __('بحث') }}
                                </button>
                                @if(request()->has('search'))
                                    <a href="{{ route('elevators.index') }}" class="btn btn-secondary ms-2">
                                        <i class="fas fa-undo"></i>
                                    </a>
                                @endif
                            </form>
                        </div>
                    </div>

                    @if(count($elevators) > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('الرقم التسلسلي') }}</th>
                                        <th>{{ __('الموديل') }}</th>
                                        <th>{{ __('الشركة المصنعة') }}</th>
                                        <th>{{ __('العميل') }}</th>
                                        <th>{{ __('الموقع') }}</th>
                                        <th>{{ __('الحالة') }}</th>
                                        <th>{{ __('تاريخ التركيب') }}</th>
                                        <th>{{ __('الإجراءات') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($elevators as $index => $elevator)
                                        <tr>
                                            <td>{{ $index + 1 + ($elevators->currentPage() - 1) * $elevators->perPage() }}</td>
                                            <td>{{ $elevator->serial_number }}</td>
                                            <td>{{ $elevator->model }}</td>
                                            <td>{{ $elevator->manufacturer }}</td>
                                            <td>{{ $elevator->customer ? $elevator->customer->name : 'غير محدد' }}</td>
                                            <td>{{ $elevator->location ? $elevator->location->name : 'غير محدد' }}</td>
                                            <td>
                                                @if($elevator->status == 'operational')
                                                    <span class="badge bg-success">يعمل</span>
                                                @elseif($elevator->status == 'maintenance')
                                                    <span class="badge bg-warning">تحت الصيانة</span>
                                                @elseif($elevator->status == 'out_of_service')
                                                    <span class="badge bg-danger">خارج الخدمة</span>
                                                @elseif($elevator->status == 'installation')
                                                    <span class="badge bg-info">قيد التركيب</span>
                                                @endif
                                            </td>
                                            <td>{{ $elevator->installation_date ? $elevator->installation_date->format('Y-m-d') : 'غير محدد' }}</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('elevators.show', $elevator->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('elevators.edit', $elevator->id) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('elevators.destroy', $elevator->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا المصعد؟');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="d-flex justify-content-center mt-4">
                            {{ $elevators->links() }}
                        </div>
                    @else
                        <div class="alert alert-info text-center">
                            {{ __('لا توجد مصاعد مسجلة حتى الآن') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection