@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('استيراد المصاعد من ملف Excel') }}</span>
                    <a href="{{ route('elevators.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-right"></i> {{ __('العودة إلى قائمة المصاعد') }}
                    </a>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    @if(session()->has('import_errors'))
                        <div class="alert alert-danger mt-2">
                            <ul>
                                @foreach(session()->get('import_errors') as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle"></i> {{ __('تعليمات الاستيراد:') }}</h5>
                        <ul>
                            <li>{{ __('يجب أن يكون الملف بتنسيق Excel (.xlsx, .xls) أو CSV.') }}</li>
                            <li>{{ __('يجب أن يحتوي الملف على العناوين التالية في الصف الأول:') }}
                                <ul>
                                    <li><code>customer_id</code> - {{ __('معرف العميل (إلزامي إذا لم يتم توفير الاسم)') }}</li>
                                    <li><code>customer_name</code> - {{ __('اسم العميل (إلزامي إذا لم يتم توفير المعرف)') }}</li>
                                    <li><code>location_id</code> - {{ __('معرف الموقع (اختياري، سيتم استخدام الموقع الافتراضي إذا تم تركه فارغاً)') }}</li>
                                    <li><code>location_name</code> - {{ __('اسم الموقع (اختياري، سيتم البحث عنه أو استخدام الموقع الافتراضي)') }}</li>
                                    <li><code>serial_number</code> - {{ __('الرقم التسلسلي (إلزامي وفريد)') }}</li>
                                    <li><code>model</code> - {{ __('الموديل (اختياري)') }}</li>
                                    <li><code>manufacturer</code> - {{ __('الشركة المصنعة (اختياري)') }}</li>
                                    <li><code>installation_date</code> - {{ __('تاريخ التركيب (اختياري، بتنسيق YYYY-MM-DD)') }}</li>
                                    <li><code>warranty_end_date</code> - {{ __('تاريخ انتهاء الضمان (اختياري، بتنسيق YYYY-MM-DD)') }}</li>
                                    <li><code>free_maintenance_end_date</code> - {{ __('تاريخ انتهاء الصيانة المجانية (اختياري، بتنسيق YYYY-MM-DD)') }}</li>
                                    <li><code>control_warranty_end_date</code> - {{ __('تاريخ انتهاء ضمان لوحة التحكم (اختياري، بتنسيق YYYY-MM-DD)') }}</li>
                                    <li><code>machine_warranty_end_date</code> - {{ __('تاريخ انتهاء ضمان الماكينة (اختياري، بتنسيق YYYY-MM-DD)') }}</li>
                                    <li><code>delivery_date</code> - {{ __('تاريخ التسليم (اختياري، بتنسيق YYYY-MM-DD)') }}</li>
                                    <li><code>capacity</code> - {{ __('السعة (اختياري، رقم)') }}</li>
                                    <li><code>floors_count</code> - {{ __('عدد الطوابق (اختياري، رقم صحيح)') }}</li>
                                    <li><code>speed</code> - {{ __('السرعة (اختياري، رقم)') }}</li>
                                    <li><code>price</code> - {{ __('السعر (اختياري، رقم)') }}</li>
                                    <li><code>type</code> - {{ __('النوع (اختياري، واحد من: passenger, freight, hospital, panoramic, residential, commercial, other)') }}</li>
                                    <li><code>status</code> - {{ __('الحالة (اختياري، واحد من: operational, under_maintenance, out_of_service, installation)') }}</li>
                                    <li><code>specifications</code> - {{ __('المواصفات (اختياري)') }}</li>
                                    <li><code>notes</code> - {{ __('ملاحظات (اختياري)') }}</li>
                                </ul>
                            </li>
                            <li>{{ __('سيتم تجاهل المصاعد ذات الأرقام التسلسلية المكررة.') }}</li>
                            <li>{{ __('إذا لم يتم تحديد موقع، سيتم استخدام موقع افتراضي.') }}</li>
                        </ul>
                    </div>

                    <div class="alert alert-warning">
                        <h5><i class="fas fa-exclamation-triangle"></i> {{ __('ملاحظة هامة:') }}</h5>
                        <p>{{ __('يجب التأكد من صحة معرفات العملاء والمواقع قبل الاستيراد. يمكنك الاطلاع على قائمة العملاء والمواقع من خلال الروابط التالية:') }}</p>
                        <ul>
                            <li><a href="{{ route('customers.index') }}" target="_blank">{{ __('قائمة العملاء') }}</a></li>
                            <li><a href="{{ route('locations.index') }}" target="_blank">{{ __('قائمة المواقع') }}</a></li>
                        </ul>
                    </div>

                    <form action="{{ route('elevators.import') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="mb-3">
                            <label for="file" class="form-label">{{ __('ملف Excel') }}</label>
                            <input type="file" class="form-control @error('file') is-invalid @enderror" id="file" name="file" required>
                            @error('file')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-file-import"></i> {{ __('استيراد') }}
                            </button>
                        </div>
                    </form>

                    <div class="mt-4">
                        <h5>{{ __('نموذج ملف الاستيراد') }}</h5>
                        <p>{{ __('يمكنك تحميل نموذج ملف للاستيراد من خلال الروابط التالية:') }}</p>
                        <div class="d-flex gap-2">
                            <a href="{{ asset('templates/elevators_import_template.csv') }}" class="btn btn-success">
                                <i class="fas fa-download"></i> {{ __('تحميل نموذج CSV') }}
                            </a>
                            <a href="{{ route('elevators.import.template.excel') }}" class="btn btn-primary">
                                <i class="fas fa-download"></i> {{ __('تحميل نموذج Excel') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection