@extends('layouts.modern')

@section('styles')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .select2-container .select2-selection--single {
        height: 38px !important;
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        line-height: 38px !important;
        padding-right: 12px;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 36px !important;
        right: auto !important;
        left: 1px !important;
    }
    .select2-container--default .select2-selection--single {
        border: 1px solid #ced4da;
    }
</style>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('تعديل بيانات المصعد') }}</span>
                    <div>
                        <a href="{{ route('elevators.show', $elevator->id) }}" class="btn btn-info btn-sm mx-1">
                            <i class="fas fa-eye"></i> {{ __('عرض') }}
                        </a>
                        <a href="{{ route('elevators.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> {{ __('العودة إلى قائمة المصاعد') }}
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    <form method="POST" action="{{ route('elevators.update', $elevator->id) }}">
                        @csrf
                        @method('PUT')

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="customer_id" class="form-label">{{ __('العميل') }} <span class="text-danger">*</span></label>
                                    <select class="form-control @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                                        <option value="">{{ __('اختر العميل') }}</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" {{ (old('customer_id', $elevator->customer_id) == $customer->id) ? 'selected' : '' }}>
                                                {{ $customer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="location_id" class="form-label">{{ __('الموقع') }}</label>
                                    <select class="form-control @error('location_id') is-invalid @enderror" id="location_id" name="location_id">
                                        <option value="">{{ __('اختر الموقع') }}</option>
                                        @foreach($locations as $location)
                                            <option value="{{ $location->id }}" {{ (old('location_id', $elevator->location_id) == $location->id) ? 'selected' : '' }}>
                                                {{ $location->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('location_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="serial_number" class="form-label">{{ __('الرقم التسلسلي') }} <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('serial_number') is-invalid @enderror" id="serial_number" name="serial_number" value="{{ old('serial_number', $elevator->serial_number) }}" required>
                                    @error('serial_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="model" class="form-label">{{ __('الموديل') }}</label>
                                    <select class="form-control @error('model') is-invalid @enderror" id="model" name="model">
                                        <option value="">{{ __('اختر الموديل') }}</option>
                                        @foreach($elevatorModels as $elevatorModel)
                                            <option value="{{ $elevatorModel->name }}" {{ (old('model', $elevator->model) == $elevatorModel->name) ? 'selected' : '' }}>
                                                {{ $elevatorModel->name }} - {{ $elevatorModel->manufacturer ?? 'غير محدد' }}
                                            </option>
                                        @endforeach
                                        <option value="أخرى" {{ !in_array(old('model', $elevator->model), $elevatorModels->pluck('name')->toArray()) ? 'selected' : '' }}>{{ __('أخرى - إدخال يدوي') }}</option>
                                    </select>
                                    <input type="text" class="form-control mt-2 custom-model @error('model') is-invalid @enderror" id="custom_model" name="custom_model" value="{{ old('custom_model', !in_array($elevator->model, $elevatorModels->pluck('name')->toArray()) ? $elevator->model : '') }}" style="{{ !in_array(old('model', $elevator->model), $elevatorModels->pluck('name')->toArray()) ? 'display: block;' : 'display: none;' }}" placeholder="{{ __('أدخل الموديل يدويًا') }}">
                                    @error('model')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="manufacturer" class="form-label">{{ __('الشركة المصنعة') }}</label>
                                    <input type="text" class="form-control @error('manufacturer') is-invalid @enderror" id="manufacturer" name="manufacturer" value="{{ old('manufacturer', $elevator->manufacturer) }}">
                                    @error('manufacturer')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="type" class="form-label">{{ __('نوع المصعد') }} <span class="text-danger">*</span></label>
                                    <select class="form-control @error('type') is-invalid @enderror" id="type" name="type" required>
                                        <option value="">{{ __('اختر نوع المصعد') }}</option>
                                        @foreach($elevatorTypes as $key => $value)
                                            <option value="{{ $key }}" {{ (old('type', $elevator->type) == $key) ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="status" class="form-label">{{ __('حالة المصعد') }} <span class="text-danger">*</span></label>
                                    <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                        <option value="">{{ __('اختر حالة المصعد') }}</option>
                                        @foreach($elevatorStatuses as $key => $value)
                                            <option value="{{ $key }}" {{ (old('status', $elevator->status) == $key) ? 'selected' : '' }}>
                                                {{ $value }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="capacity" class="form-label">{{ __('السعة (كجم)') }}</label>
                                    <input type="number" step="0.01" min="1" class="form-control @error('capacity') is-invalid @enderror" id="capacity" name="capacity" value="{{ old('capacity', $elevator->capacity) }}">
                                    @error('capacity')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="floors_count" class="form-label">{{ __('عدد الطوابق') }}</label>
                                    <input type="number" min="2" class="form-control @error('floors_count') is-invalid @enderror" id="floors_count" name="floors_count" value="{{ old('floors_count', $elevator->floors_count) }}">
                                    @error('floors_count')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="speed" class="form-label">{{ __('السرعة (م/ث)') }}</label>
                                    <input type="number" step="0.01" min="0.1" class="form-control @error('speed') is-invalid @enderror" id="speed" name="speed" value="{{ old('speed', $elevator->speed) }}">
                                    @error('speed')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="price" class="form-label">{{ __('سعر المصعد') }} <span class="text-danger price-required {{ $elevator->status == 'installation' ? '' : 'd-none' }}">*</span></label>
                                    <input type="number" step="0.01" min="0" class="form-control @error('price') is-invalid @enderror" id="price" name="price" value="{{ old('price', $elevator->price) }}" {{ $elevator->status == 'installation' ? 'required' : '' }}>
                                    @error('price')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="installation_date" class="form-label">{{ __('تاريخ التركيب') }}</label>
                                    <input type="date" class="form-control @error('installation_date') is-invalid @enderror" id="installation_date" name="installation_date" value="{{ old('installation_date', $elevator->installation_date ? $elevator->installation_date->format('Y-m-d') : '') }}">
                                    @error('installation_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="warranty_end_date" class="form-label">{{ __('تاريخ انتهاء الضمان') }}</label>
                                    <input type="date" class="form-control @error('warranty_end_date') is-invalid @enderror" id="warranty_end_date" name="warranty_end_date" value="{{ old('warranty_end_date', $elevator->warranty_end_date ? $elevator->warranty_end_date->format('Y-m-d') : '') }}">
                                    @error('warranty_end_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="free_maintenance_end_date" class="form-label">{{ __('تاريخ انتهاء الصيانة المجانية') }}</label>
                                    <input type="date" class="form-control @error('free_maintenance_end_date') is-invalid @enderror" id="free_maintenance_end_date" name="free_maintenance_end_date" value="{{ old('free_maintenance_end_date', $elevator->free_maintenance_end_date ? $elevator->free_maintenance_end_date->format('Y-m-d') : '') }}">
                                    @error('free_maintenance_end_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="control_warranty_end_date" class="form-label">{{ __('تاريخ انتهاء ضمان الكنترول') }}</label>
                                    <input type="date" class="form-control @error('control_warranty_end_date') is-invalid @enderror" id="control_warranty_end_date" name="control_warranty_end_date" value="{{ old('control_warranty_end_date', $elevator->control_warranty_end_date ? $elevator->control_warranty_end_date->format('Y-m-d') : '') }}">
                                    @error('control_warranty_end_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="machine_warranty_end_date" class="form-label">{{ __('تاريخ انتهاء ضمان الماكينة') }}</label>
                                    <input type="date" class="form-control @error('machine_warranty_end_date') is-invalid @enderror" id="machine_warranty_end_date" name="machine_warranty_end_date" value="{{ old('machine_warranty_end_date', $elevator->machine_warranty_end_date ? $elevator->machine_warranty_end_date->format('Y-m-d') : '') }}">
                                    @error('machine_warranty_end_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="delivery_date" class="form-label">{{ __('تاريخ تسليم المصعد') }}</label>
                                    <input type="date" class="form-control @error('delivery_date') is-invalid @enderror" id="delivery_date" name="delivery_date" value="{{ old('delivery_date', $elevator->delivery_date ? $elevator->delivery_date->format('Y-m-d') : '') }}">
                                    @error('delivery_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="specifications" class="form-label">{{ __('المواصفات الفنية') }}</label>
                                    <textarea class="form-control @error('specifications') is-invalid @enderror" id="specifications" name="specifications" rows="3">{{ old('specifications', $elevator->specifications) }}</textarea>
                                    @error('specifications')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="notes" class="form-label">{{ __('ملاحظات') }}</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $elevator->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> {{ __('حفظ التغييرات') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('#customer_id').select2({
            dir: "rtl",
            placeholder: "{{ __('اختر العميل') }}",
            allowClear: true,
            width: '100%'
        });

        $('#location_id').select2({
            dir: "rtl",
            placeholder: "{{ __('اختر الموقع') }}",
            allowClear: true,
            width: '100%'
        });
        
        $('#model').select2({
            dir: "rtl",
            placeholder: "{{ __('اختر الموديل') }}",
            allowClear: true,
            width: '100%'
        });
    });

    document.addEventListener('DOMContentLoaded', function() {
        const statusSelect = document.getElementById('status');
        const priceInput = document.getElementById('price');
        const priceRequired = document.querySelector('.price-required');

        // تحديث حالة حقل السعر عند تغيير حالة المصعد
        statusSelect.addEventListener('change', function() {
            if (this.value === 'installation') {
                priceInput.setAttribute('required', 'required');
                priceRequired.classList.remove('d-none');
            } else {
                priceInput.removeAttribute('required');
                priceRequired.classList.add('d-none');
            }
        });
        
        // التعامل مع خيار "أخرى" في قائمة الموديلات
        const modelSelect = document.getElementById('model');
        const customModelInput = document.getElementById('custom_model');
        
        // عند تغيير قيمة القائمة المنسدلة
        modelSelect.addEventListener('change', function() {
            if (this.value === 'أخرى') {
                customModelInput.style.display = 'block';
                customModelInput.required = true;
                customModelInput.focus();
            } else {
                customModelInput.style.display = 'none';
                customModelInput.required = false;
            }
        });
        
        // عند تقديم النموذج
        document.querySelector('form').addEventListener('submit', function(e) {
            if (modelSelect.value === 'أخرى' && customModelInput.value.trim() === '') {
                e.preventDefault();
                alert('الرجاء إدخال اسم الموديل');
                customModelInput.focus();
            } else if (modelSelect.value === 'أخرى') {
                // استبدال قيمة الموديل بالقيمة المدخلة يدويًا
                modelSelect.value = customModelInput.value;
            }
        });
    });
</script>
@endsection