@extends('layouts.app')

@section('title', 'مراحل المصاعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مراحل المصاعد</h3>
                    <div class="card-tools">
                        @can('elevator_stages.create')
                        <a href="{{ route('elevator-stages.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة مرحلة جديدة
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>اسم المرحلة</th>
                                    <th>نسبة المرحلة من قيمة العقد</th>
                                    <th>ترتيب المرحلة</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($stages as $stage)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $stage->name }}</td>
                                    <td>{{ $stage->percentage }}%</td>
                                    <td>{{ $stage->order }}</td>
                                    <td>
                                        @if($stage->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            @can('elevator_stages.view')
                                            <a href="{{ route('elevator-stages.show', $stage->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan
                                            
                                            @can('elevator_stages.edit')
                                            <a href="{{ route('elevator-stages.edit', $stage->id) }}" class="btn btn-warning btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan
                                            
                                            @can('elevator_stages.delete')
                                            <form action="{{ route('elevator-stages.destroy', $stage->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذه المرحلة؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد مراحل مسجلة</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $stages->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection