@extends('layouts.app')

@section('title', 'تفاصيل طلب المخزون للمصاعد')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل طلب المخزون للمصاعد #{{ $elevatorInventoryRequest->request_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-inventory.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        @if(in_array($elevatorInventoryRequest->status, ['draft', 'pending', 'rejected']))
                            <a href="{{ route('elevator-inventory.edit', $elevatorInventoryRequest) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات الطلب</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الطلب</th>
                                            <td>{{ $elevatorInventoryRequest->request_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @switch($elevatorInventoryRequest->status)
                                                    @case('draft')
                                                        <span class="badge badge-secondary">مسودة</span>
                                                        @break
                                                    @case('pending')
                                                        <span class="badge badge-warning">معلق</span>
                                                        @break
                                                    @case('approved')
                                                        <span class="badge badge-info">معتمد</span>
                                                        @break
                                                    @case('rejected')
                                                        <span class="badge badge-danger">مرفوض</span>
                                                        @break
                                                    @case('fulfilled')
                                                        <span class="badge badge-success">تم التنفيذ</span>
                                                        @break
                                                    @case('partially_fulfilled')
                                                        <span class="badge badge-primary">تم التنفيذ جزئياً</span>
                                                        @break
                                                    @case('cancelled')
                                                        <span class="badge badge-dark">ملغي</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $elevatorInventoryRequest->status }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الشركة</th>
                                            <td>{{ $elevatorInventoryRequest->company->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الطلب</th>
                                            <td>{{ $elevatorInventoryRequest->requested_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الاستحقاق</th>
                                            <td>{{ $elevatorInventoryRequest->required_date->format('Y-m-d') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات إضافية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">مقدم الطلب</th>
                                            <td>{{ $elevatorInventoryRequest->requester->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>معتمد بواسطة</th>
                                            <td>{{ $elevatorInventoryRequest->approver->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الاعتماد</th>
                                            <td>{{ $elevatorInventoryRequest->approval_date ? $elevatorInventoryRequest->approval_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ التنفيذ</th>
                                            <td>{{ $elevatorInventoryRequest->fulfillment_date ? $elevatorInventoryRequest->fulfillment_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>ملاحظات</th>
                                            <td>{{ $elevatorInventoryRequest->notes ?? 'لا توجد ملاحظات' }}</td>
                                        </tr>
                                        @if($elevatorInventoryRequest->status == 'rejected')
                                            <tr>
                                                <th>سبب الرفض</th>
                                                <td>{{ $elevatorInventoryRequest->rejection_reason }}</td>
                                            </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">عناصر الطلب</h5>
                                </div>
                                <div class="card-body">
                                    @if($elevatorInventoryRequest->status == 'approved' && request()->has('fulfill'))
                                        <form action="{{ route('elevator-inventory.fulfill', $elevatorInventoryRequest) }}" method="POST">
                                            @csrf
                                            @method('PATCH')
                                            <div class="table-responsive">
                                                <table class="table table-bordered">
                                                    <thead>
                                                        <tr>
                                                            <th>العنصر</th>
                                                            <th>المستودع</th>
                                                            <th>الكمية المطلوبة</th>
                                                            <th>الكمية المنفذة</th>
                                                            <th>الأولوية</th>
                                                            <th>الحالة</th>
                                                            <th>ملاحظات</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($elevatorInventoryRequest->items as $index => $item)
                                                            <tr>
                                                                <td>{{ $item->item->name }} ({{ $item->item->item_code }})</td>
                                                                <td>{{ $item->warehouse->name }}</td>
                                                                <td>{{ $item->quantity }}</td>
                                                                <td>
                                                                    <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
                                                                    <input type="number" name="items[{{ $index }}][fulfilled_quantity]" class="form-control" step="0.01" min="0" max="{{ $item->quantity }}" value="{{ $item->quantity }}" required>
                                                                </td>
                                                                <td>
                                                                    @switch($item->priority)
                                                                        @case('low')
                                                                            <span class="badge badge-secondary">منخفضة</span>
                                                                            @break
                                                                        @case('medium')
                                                                            <span class="badge badge-info">متوسطة</span>
                                                                            @break
                                                                        @case('high')
                                                                            <span class="badge badge-warning">عالية</span>
                                                                            @break
                                                                        @case('urgent')
                                                                            <span class="badge badge-danger">عاجلة</span>
                                                                            @break
                                                                        @default
                                                                            <span class="badge badge-secondary">{{ $item->priority }}</span>
                                                                    @endswitch
                                                                </td>
                                                                <td>
                                                                    @switch($item->status)
                                                                        @case('pending')
                                                                            <span class="badge badge-warning">معلق</span>
                                                                            @break
                                                                        @case('approved')
                                                                            <span class="badge badge-info">معتمد</span>
                                                                            @break
                                                                        @case('rejected')
                                                                            <span class="badge badge-danger">مرفوض</span>
                                                                            @break
                                                                        @case('fulfilled')
                                                                            <span class="badge badge-success">تم التنفيذ</span>
                                                                            @break
                                                                        @case('partially_fulfilled')
                                                                            <span class="badge badge-primary">تم التنفيذ جزئياً</span>
                                                                            @break
                                                                        @default
                                                                            <span class="badge badge-secondary">{{ $item->status }}</span>
                                                                    @endswitch
                                                                </td>
                                                                <td>{{ $item->notes ?? 'لا توجد ملاحظات' }}</td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                            
                                            <div class="form-group mt-3">
                                                <button type="submit" class="btn btn-success">
                                                    <i class="fas fa-check-double"></i> تنفيذ الطلب
                                                </button>
                                                <a href="{{ route('elevator-inventory.show', $elevatorInventoryRequest) }}" class="btn btn-secondary">
                                                    <i class="fas fa-times"></i> إلغاء
                                                </a>
                                            </div>
                                        </form>
                                    @else
                                        <div class="table-responsive">
                                            <table class="table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>العنصر</th>
                                                        <th>المستودع</th>
                                                        <th>الكمية المطلوبة</th>
                                                        <th>الكمية المنفذة</th>
                                                        <th>الأولوية</th>
                                                        <th>الحالة</th>
                                                        <th>ملاحظات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($elevatorInventoryRequest->items as $item)
                                                        <tr>
                                                            <td>{{ $item->item->name }} ({{ $item->item->item_code }})</td>
                                                            <td>{{ $item->warehouse->name }}</td>
                                                            <td>{{ $item->quantity }}</td>
                                                            <td>{{ $item->fulfilled_quantity }}</td>
                                                            <td>
                                                                @switch($item->priority)
                                                                    @case('low')
                                                                        <span class="badge badge-secondary">منخفضة</span>
                                                                        @break
                                                                    @case('medium')
                                                                        <span class="badge badge-info">متوسطة</span>
                                                                        @break
                                                                    @case('high')
                                                                        <span class="badge badge-warning">عالية</span>
                                                                        @break
                                                                    @case('urgent')
                                                                        <span class="badge badge-danger">عاجلة</span>
                                                                        @break
                                                                    @default
                                                                        <span class="badge badge-secondary">{{ $item->priority }}</span>
                                                                @endswitch
                                                            </td>
                                                            <td>
                                                                @switch($item->status)
                                                                    @case('pending')
                                                                        <span class="badge badge-warning">معلق</span>
                                                                        @break
                                                                    @case('approved')
                                                                        <span class="badge badge-info">معتمد</span>
                                                                        @break
                                                                    @case('rejected')
                                                                        <span class="badge badge-danger">مرفوض</span>
                                                                        @break
                                                                    @case('fulfilled')
                                                                        <span class="badge badge-success">تم التنفيذ</span>
                                                                        @break
                                                                    @case('partially_fulfilled')
                                                                        <span class="badge badge-primary">تم التنفيذ جزئياً</span>
                                                                        @break
                                                                    @default
                                                                        <span class="badge badge-secondary">{{ $item->status }}</span>
                                                                @endswitch
                                                            </td>
                                                            <td>{{ $item->notes ?? 'لا توجد ملاحظات' }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="btn-group">
                                @if($elevatorInventoryRequest->status == 'pending')
                                    <form action="{{ route('elevator-inventory.approve', $elevatorInventoryRequest) }}" method="POST" style="display: inline;">
                                        @csrf
                                        @method('PATCH')
                                        <button type="submit" class="btn btn-success" onclick="return confirm('هل أنت متأكد من اعتماد هذا الطلب؟')">
                                            <i class="fas fa-check"></i> اعتماد الطلب
                                        </button>
                                    </form>
                                    <button type="button" class="btn btn-danger" data-toggle="modal" data-target="#rejectModal">
                                        <i class="fas fa-times"></i> رفض الطلب
                                    </button>
                                @endif
                                
                                @if($elevatorInventoryRequest->status == 'approved')
                                    <a href="{{ route('elevator-inventory.show', $elevatorInventoryRequest) }}?fulfill=1" class="btn btn-success">
                                        <i class="fas fa-check-double"></i> تنفيذ الطلب
                                    </a>
                                @endif
                                
                                @if(in_array($elevatorInventoryRequest->status, ['draft', 'pending', 'rejected']))
                                    <form action="{{ route('elevator-inventory.destroy', $elevatorInventoryRequest) }}" method="POST" style="display: inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا الطلب؟')">
                                            <i class="fas fa-trash"></i> حذف الطلب
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Rejection -->
<div class="modal fade" id="rejectModal" tabindex="-1" role="dialog" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="{{ route('elevator-inventory.reject', $elevatorInventoryRequest) }}" method="POST">
                @csrf
                @method('PATCH')
                <div class="modal-header">
                    <h5 class="modal-title" id="rejectModalLabel">رفض طلب المخزون</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="rejection_reason">سبب الرفض</label>
                        <textarea name="rejection_reason" id="rejection_reason" class="form-control" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">تأكيد الرفض</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection