@extends('layouts.app')

@section('title', 'طلبات المخزون للمصاعد')

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">طلبات المخزون للمصاعد</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-inventory.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إنشاء طلب جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم الطلب</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الطلب</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>مقدم الطلب</th>
                                    <th>معتمد بواسطة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($requests as $request)
                                    <tr>
                                        <td>{{ $request->request_number }}</td>
                                        <td>
                                            @switch($request->status)
                                                @case('draft')
                                                    <span class="badge badge-secondary">مسودة</span>
                                                    @break
                                                @case('pending')
                                                    <span class="badge badge-warning">معلق</span>
                                                    @break
                                                @case('approved')
                                                    <span class="badge badge-info">معتمد</span>
                                                    @break
                                                @case('rejected')
                                                    <span class="badge badge-danger">مرفوض</span>
                                                    @break
                                                @case('fulfilled')
                                                    <span class="badge badge-success">تم التنفيذ</span>
                                                    @break
                                                @case('partially_fulfilled')
                                                    <span class="badge badge-primary">تم التنفيذ جزئياً</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge badge-dark">ملغي</span>
                                                    @break
                                                @default
                                                    <span class="badge badge-secondary">{{ $request->status }}</span>
                                            @endswitch
                                        </td>
                                        <td>{{ $request->requested_date->format('Y-m-d') }}</td>
                                        <td>{{ $request->required_date->format('Y-m-d') }}</td>
                                        <td>{{ $request->requester->name ?? 'غير محدد' }}</td>
                                        <td>{{ $request->approver->name ?? 'غير محدد' }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('elevator-inventory.show', $request) }}" class="btn btn-info btn-sm">
                                                    <i class="fas fa-eye"></i> عرض
                                                </a>
                                                @if(in_array($request->status, ['draft', 'pending', 'rejected']))
                                                    <a href="{{ route('elevator-inventory.edit', $request) }}" class="btn btn-primary btn-sm">
                                                        <i class="fas fa-edit"></i> تعديل
                                                    </a>
                                                @endif
                                                @if($request->status == 'pending')
                                                    <form action="{{ route('elevator-inventory.approve', $request) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('PATCH')
                                                        <button type="submit" class="btn btn-success btn-sm" onclick="return confirm('هل أنت متأكد من اعتماد هذا الطلب؟')">
                                                            <i class="fas fa-check"></i> اعتماد
                                                        </button>
                                                    </form>
                                                    <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#rejectModal{{ $request->id }}">
                                                        <i class="fas fa-times"></i> رفض
                                                    </button>
                                                @endif
                                                @if($request->status == 'approved')
                                                    <a href="{{ route('elevator-inventory.show', $request) }}?fulfill=1" class="btn btn-success btn-sm">
                                                        <i class="fas fa-check-double"></i> تنفيذ
                                                    </a>
                                                @endif
                                                @if(in_array($request->status, ['draft', 'pending', 'rejected']))
                                                    <form action="{{ route('elevator-inventory.destroy', $request) }}" method="POST" style="display: inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا الطلب؟')">
                                                            <i class="fas fa-trash"></i> حذف
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                            
                                            <!-- Modal for Rejection -->
                                            <div class="modal fade" id="rejectModal{{ $request->id }}" tabindex="-1" role="dialog" aria-labelledby="rejectModalLabel{{ $request->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <form action="{{ route('elevator-inventory.reject', $request) }}" method="POST">
                                                            @csrf
                                                            @method('PATCH')
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="rejectModalLabel{{ $request->id }}">رفض طلب المخزون</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="rejection_reason">سبب الرفض</label>
                                                                    <textarea name="rejection_reason" id="rejection_reason" class="form-control" rows="3" required></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-danger">تأكيد الرفض</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">لا توجد طلبات مخزون للمصاعد</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $requests->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection