@extends('layouts.app')

@section('title', 'تعديل طلب المخزون للمصاعد')

@section('styles')
<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
<style>
    .select2-container--default .select2-selection--single {
        height: 38px;
        line-height: 38px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل طلب المخزون للمصاعد #{{ $elevatorInventoryRequest->request_number }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-inventory.show', $elevatorInventoryRequest) }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للتفاصيل
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('elevator-inventory.update', $elevatorInventoryRequest) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_id">الشركة</label>
                                    <select name="company_id" id="company_id" class="form-control select2 @error('company_id') is-invalid @enderror" disabled>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}" {{ $elevatorInventoryRequest->company_id == $company->id ? 'selected' : '' }}>
                                                {{ $company->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <input type="hidden" name="company_id" value="{{ $elevatorInventoryRequest->company_id }}">
                                    @error('company_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="required_date">تاريخ الاستحقاق</label>
                                    <input type="date" name="required_date" id="required_date" class="form-control @error('required_date') is-invalid @enderror" value="{{ old('required_date', $elevatorInventoryRequest->required_date->format('Y-m-d')) }}" required>
                                    @error('required_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $elevatorInventoryRequest->notes) }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <hr>
                        
                        <h4>عناصر الطلب</h4>
                        <div class="table-responsive">
                            <table class="table table-bordered" id="items-table">
                                <thead>
                                    <tr>
                                        <th>العنصر</th>
                                        <th>المستودع</th>
                                        <th>الكمية</th>
                                        <th>الأولوية</th>
                                        <th>ملاحظات</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($elevatorInventoryRequest->items as $index => $item)
                                        <tr class="item-row">
                                            <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
                                            <td>
                                                <select name="items[{{ $index }}][inventory_item_id]" class="form-control select2 inventory-item" required>
                                                    <option value="">اختر العنصر</option>
                                                    @foreach($inventoryItems as $inventoryItem)
                                                        <option value="{{ $inventoryItem->id }}" {{ $item->inventory_item_id == $inventoryItem->id ? 'selected' : '' }}>
                                                            {{ $inventoryItem->name }} ({{ $inventoryItem->item_code }})
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td>
                                                <select name="items[{{ $index }}][warehouse_id]" class="form-control select2" required>
                                                    <option value="">اختر المستودع</option>
                                                    @foreach($warehouses as $warehouse)
                                                        <option value="{{ $warehouse->id }}" {{ $item->warehouse_id == $warehouse->id ? 'selected' : '' }}>
                                                            {{ $warehouse->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td>
                                                <input type="number" name="items[{{ $index }}][quantity]" class="form-control" step="0.01" min="0.01" value="{{ $item->quantity }}" required>
                                            </td>
                                            <td>
                                                <select name="items[{{ $index }}][priority]" class="form-control" required>
                                                    <option value="low" {{ $item->priority == 'low' ? 'selected' : '' }}>منخفضة</option>
                                                    <option value="medium" {{ $item->priority == 'medium' ? 'selected' : '' }}>متوسطة</option>
                                                    <option value="high" {{ $item->priority == 'high' ? 'selected' : '' }}>عالية</option>
                                                    <option value="urgent" {{ $item->priority == 'urgent' ? 'selected' : '' }}>عاجلة</option>
                                                </select>
                                            </td>
                                            <td>
                                                <input type="text" name="items[{{ $index }}][notes]" class="form-control" value="{{ $item->notes }}">
                                            </td>
                                            <td>
                                                <button type="button" class="btn btn-danger btn-sm remove-item">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="6">
                                            <button type="button" class="btn btn-success btn-sm" id="add-item">
                                                <i class="fas fa-plus"></i> إضافة عنصر
                                            </button>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ التعديلات
                            </button>
                            <a href="{{ route('elevator-inventory.show', $elevatorInventoryRequest) }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>
<script>
    $(function() {
        $('.select2').select2({
            theme: 'bootstrap4'
        });
        
        // إضافة عنصر جديد
        $('#add-item').click(function() {
            var rowCount = $('.item-row').length;
            var newRow = $('.item-row:first').clone();
            
            // تحديث أسماء الحقول
            newRow.find('select, input').each(function() {
                var name = $(this).attr('name');
                if (name) {
                    name = name.replace(/\[\d+\]/g, '[' + rowCount + ']');
                    $(this).attr('name', name);
                }
            });
            
            // إعادة تعيين القيم
            newRow.find('input[type="hidden"]').remove();
            newRow.find('input[type="number"]').val('');
            newRow.find('input[type="text"]').val('');
            newRow.find('select').val('');
            
            // إعادة تهيئة Select2
            newRow.find('.select2').removeClass('select2-hidden-accessible').next('.select2-container').remove();
            
            // إضافة الصف الجديد
            $('#items-table tbody').append(newRow);
            
            // إعادة تهيئة Select2 للعناصر الجديدة
            newRow.find('.select2').select2({
                theme: 'bootstrap4'
            });
        });
        
        // حذف عنصر
        $(document).on('click', '.remove-item', function() {
            if ($('.item-row').length > 1) {
                $(this).closest('tr').remove();
            } else {
                alert('يجب أن يحتوي الطلب على عنصر واحد على الأقل');
            }
        });
    });
</script>
@endsection