@extends('layouts.app')

@section('title', 'عرض محضر تسليم المصعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">عرض محضر تسليم المصعد</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-deliveries.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        <a href="{{ route('elevator-deliveries.edit', $delivery->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('elevator-deliveries.print', $delivery->id) }}" class="btn btn-secondary" target="_blank">
                            <i class="fas fa-print"></i> طباعة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>رقم المصعد:</label>
                                <p class="form-control-static">{{ $delivery->elevator->serial_number }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>اسم العميل:</label>
                                <p class="form-control-static">{{ $delivery->elevator->customer->name }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>موديل المصعد:</label>
                                <p class="form-control-static">{{ $delivery->elevator->model }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ محضر الاستلام:</label>
                                <p class="form-control-static">{{ $delivery->delivery_date->format('Y-m-d') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ انتهاء ضمان التشغيل:</label>
                                <p class="form-control-static">{{ $delivery->warranty_end_date ? $delivery->warranty_end_date->format('Y-m-d') : 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ انتهاء الصيانة المجانية:</label>
                                <p class="form-control-static">{{ $delivery->free_maintenance_end_date ? $delivery->free_maintenance_end_date->format('Y-m-d') : 'غير محدد' }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ انتهاء ضمان الكنترول:</label>
                                <p class="form-control-static">{{ $delivery->control_warranty_end_date ? $delivery->control_warranty_end_date->format('Y-m-d') : 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ انتهاء ضمان الماكينة:</label>
                                <p class="form-control-static">{{ $delivery->machine_warranty_end_date ? $delivery->machine_warranty_end_date->format('Y-m-d') : 'غير محدد' }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>ملاحظات:</label>
                                <p class="form-control-static">{{ $delivery->notes ?: 'لا توجد ملاحظات' }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ إنشاء المحضر:</label>
                                <p class="form-control-static">{{ $delivery->created_at->format('Y-m-d H:i') }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تم الإنشاء بواسطة:</label>
                                <p class="form-control-static">{{ $delivery->user->name }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <a href="{{ route('elevator-deliveries.index') }}" class="btn btn-default">
                                <i class="fas fa-arrow-right"></i> العودة للقائمة
                            </a>
                            <a href="{{ route('elevator-deliveries.edit', $delivery->id) }}" class="btn btn-warning">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            <a href="{{ route('elevator-deliveries.print', $delivery->id) }}" class="btn btn-secondary" target="_blank">
                                <i class="fas fa-print"></i> طباعة
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection