<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>محضر تسليم مصعد</title>
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            direction: rtl;
            text-align: right;
            font-size: 14px;
            line-height: 1.5;
        }
        .container {
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: bold;
        }
        .header h2 {
            margin: 10px 0 0;
            font-size: 18px;
        }
        .company-info {
            margin-bottom: 20px;
        }
        .delivery-info {
            margin-bottom: 30px;
        }
        .info-section {
            margin-bottom: 20px;
        }
        .info-section h3 {
            margin: 0 0 10px;
            font-size: 16px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 5px;
        }
        .info-row {
            display: flex;
            margin-bottom: 10px;
        }
        .info-label {
            font-weight: bold;
            width: 200px;
        }
        .info-value {
            flex: 1;
        }
        .signatures {
            margin-top: 50px;
            display: flex;
            justify-content: space-between;
        }
        .signature-box {
            width: 45%;
            text-align: center;
        }
        .signature-line {
            margin-top: 50px;
            border-top: 1px solid #000;
            padding-top: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        .notes {
            margin-top: 30px;
            border: 1px solid #ddd;
            padding: 10px;
            min-height: 80px;
        }
        @media print {
            body {
                font-size: 12px;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>{{ $delivery->company->name }}</h1>
            <h2>محضر تسليم مصعد</h2>
        </div>

        <div class="company-info">
            <div class="info-row">
                <div class="info-label">رقم المحضر:</div>
                <div class="info-value">{{ $delivery->id }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">تاريخ المحضر:</div>
                <div class="info-value">{{ $delivery->delivery_date->format('Y-m-d') }}</div>
            </div>
        </div>

        <div class="info-section">
            <h3>معلومات العميل</h3>
            <div class="info-row">
                <div class="info-label">اسم العميل:</div>
                <div class="info-value">{{ $delivery->elevator->customer->name }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">رقم الهاتف:</div>
                <div class="info-value">{{ $delivery->elevator->customer->phone ?? 'غير متوفر' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">العنوان:</div>
                <div class="info-value">{{ $delivery->elevator->customer->address ?? 'غير متوفر' }}</div>
            </div>
        </div>

        <div class="info-section">
            <h3>معلومات المصعد</h3>
            <div class="info-row">
                <div class="info-label">رقم المصعد:</div>
                <div class="info-value">{{ $delivery->elevator->serial_number }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">موديل المصعد:</div>
                <div class="info-value">{{ $delivery->elevator->model }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">الشركة المصنعة:</div>
                <div class="info-value">{{ $delivery->elevator->manufacturer }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">نوع المصعد:</div>
                <div class="info-value">
                    @switch($delivery->elevator->type)
                        @case('passenger')
                            مصعد ركاب
                            @break
                        @case('freight')
                            مصعد بضائع
                            @break
                        @case('hospital')
                            مصعد مستشفى
                            @break
                        @case('panoramic')
                            مصعد بانورامي
                            @break
                        @default
                            {{ $delivery->elevator->type }}
                    @endswitch
                </div>
            </div>
            <div class="info-row">
                <div class="info-label">الحمولة:</div>
                <div class="info-value">{{ $delivery->elevator->capacity }} كجم</div>
            </div>
            <div class="info-row">
                <div class="info-label">عدد الطوابق:</div>
                <div class="info-value">{{ $delivery->elevator->floors_count }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">السرعة:</div>
                <div class="info-value">{{ $delivery->elevator->speed }} م/ث</div>
            </div>
        </div>

        <div class="info-section">
            <h3>معلومات الضمان والصيانة</h3>
            <table>
                <thead>
                    <tr>
                        <th>البيان</th>
                        <th>تاريخ البدء</th>
                        <th>تاريخ الانتهاء</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>ضمان التشغيل</td>
                        <td>{{ $delivery->delivery_date->format('Y-m-d') }}</td>
                        <td>{{ $delivery->warranty_end_date ? $delivery->warranty_end_date->format('Y-m-d') : 'غير محدد' }}</td>
                    </tr>
                    <tr>
                        <td>الصيانة المجانية</td>
                        <td>{{ $delivery->delivery_date->format('Y-m-d') }}</td>
                        <td>{{ $delivery->free_maintenance_end_date ? $delivery->free_maintenance_end_date->format('Y-m-d') : 'غير محدد' }}</td>
                    </tr>
                    <tr>
                        <td>ضمان الكنترول</td>
                        <td>{{ $delivery->delivery_date->format('Y-m-d') }}</td>
                        <td>{{ $delivery->control_warranty_end_date ? $delivery->control_warranty_end_date->format('Y-m-d') : 'غير محدد' }}</td>
                    </tr>
                    <tr>
                        <td>ضمان الماكينة</td>
                        <td>{{ $delivery->delivery_date->format('Y-m-d') }}</td>
                        <td>{{ $delivery->machine_warranty_end_date ? $delivery->machine_warranty_end_date->format('Y-m-d') : 'غير محدد' }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="info-section">
            <h3>ملاحظات</h3>
            <div class="notes">
                {{ $delivery->notes ?: 'لا توجد ملاحظات' }}
            </div>
        </div>

        <div class="signatures">
            <div class="signature-box">
                <div>ممثل الشركة</div>
                <div class="signature-line">التوقيع</div>
            </div>
            <div class="signature-box">
                <div>العميل</div>
                <div class="signature-line">التوقيع</div>
            </div>
        </div>

        <div class="no-print" style="margin-top: 30px; text-align: center;">
            <button onclick="window.print();" style="padding: 10px 20px; background-color: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer;">
                طباعة المحضر
            </button>
        </div>
    </div>
</body>
</html>