@extends('layouts.app')

@section('title', 'محاضر تسليم المصاعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">محاضر تسليم المصاعد</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-deliveries.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة محضر تسليم جديد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>رقم المصعد</th>
                                    <th>اسم العميل</th>
                                    <th>موديل المصعد</th>
                                    <th>تاريخ التسليم</th>
                                    <th>تاريخ انتهاء الضمان</th>
                                    <th>تاريخ انتهاء الصيانة المجانية</th>
                                    <th>تاريخ إنشاء المحضر</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($deliveries as $delivery)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $delivery->elevator->serial_number }}</td>
                                        <td>{{ $delivery->elevator->customer->name }}</td>
                                        <td>{{ $delivery->elevator->model }}</td>
                                        <td>{{ $delivery->delivery_date->format('Y-m-d') }}</td>
                                        <td>{{ $delivery->warranty_end_date ? $delivery->warranty_end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        <td>{{ $delivery->free_maintenance_end_date ? $delivery->free_maintenance_end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        <td>{{ $delivery->created_at->format('Y-m-d') }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('elevator-deliveries.show', $delivery->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i> عرض
                                                </a>
                                                <a href="{{ route('elevator-deliveries.edit', $delivery->id) }}" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i> تعديل
                                                </a>
                                                <a href="{{ route('elevator-deliveries.print', $delivery->id) }}" class="btn btn-sm btn-secondary" target="_blank">
                                                    <i class="fas fa-print"></i> طباعة
                                                </a>
                                                <form action="{{ route('elevator-deliveries.destroy', $delivery->id) }}" method="POST" style="display: inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا المحضر؟')">
                                                        <i class="fas fa-trash"></i> حذف
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد محاضر تسليم مسجلة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $deliveries->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection