@extends('layouts.app')

@section('title', 'إضافة محضر تسليم مصعد جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة محضر تسليم مصعد جديد</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-deliveries.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('elevator-deliveries.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">رقم المصعد <span class="text-danger">*</span></label>
                                    <select name="elevator_id" id="elevator_id" class="form-control select2" required>
                                        <option value="">-- اختر المصعد --</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ old('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->serial_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_name">اسم العميل</label>
                                    <input type="text" id="customer_name" class="form-control" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_model">موديل المصعد</label>
                                    <input type="text" id="elevator_model" class="form-control" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="delivery_date">تاريخ محضر الاستلام <span class="text-danger">*</span></label>
                                    <input type="date" name="delivery_date" id="delivery_date" class="form-control" value="{{ old('delivery_date') ?? date('Y-m-d') }}" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="warranty_end_date">تاريخ انتهاء ضمان التشغيل</label>
                                    <input type="date" name="warranty_end_date" id="warranty_end_date" class="form-control" value="{{ old('warranty_end_date') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="free_maintenance_end_date">تاريخ انتهاء الصيانة المجانية</label>
                                    <input type="date" name="free_maintenance_end_date" id="free_maintenance_end_date" class="form-control" value="{{ old('free_maintenance_end_date') }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="control_warranty_end_date">تاريخ انتهاء ضمان الكنترول</label>
                                    <input type="date" name="control_warranty_end_date" id="control_warranty_end_date" class="form-control" value="{{ old('control_warranty_end_date') }}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="machine_warranty_end_date">تاريخ انتهاء ضمان الماكينة</label>
                                    <input type="date" name="machine_warranty_end_date" id="machine_warranty_end_date" class="form-control" value="{{ old('machine_warranty_end_date') }}">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control" rows="3">{{ old('notes') }}</textarea>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ
                                </button>
                                <a href="{{ route('elevator-deliveries.index') }}" class="btn btn-default">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize select2
        $('.select2').select2();

        // Get elevator details when elevator is selected
        $('#elevator_id').change(function() {
            var elevatorId = $(this).val();
            if (elevatorId) {
                $.ajax({
                    url: "{{ route('elevator-deliveries.get-elevator-details') }}",
                    type: "POST",
                    data: {
                        elevator_id: elevatorId,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: "json",
                    success: function(data) {
                        $('#customer_name').val(data.customer_name);
                        $('#elevator_model').val(data.model);
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error:", status, error);
                    }
                });
            } else {
                $('#customer_name').val('');
                $('#elevator_model').val('');
            }
        });

        // Trigger change if a value is already selected (e.g. on form validation error)
        if ($('#elevator_id').val()) {
            $('#elevator_id').trigger('change');
        }
    });
</script>
@endpush