@extends('layouts.app')

@section('title', 'تقرير انتهاء ضمان المصاعد')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">تقرير انتهاء ضمان المصاعد</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('elevator-reports.index') }}">تقارير المصاعد</a></li>
                    <li class="breadcrumb-item active">تقرير انتهاء ضمان المصاعد</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">فلترة التقرير</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('elevator-reports.warranty') }}" method="GET" class="mb-4">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="customer_id">رقم العميل</label>
                                        <select name="customer_id" id="customer_id" class="form-control">
                                            <option value="">جميع العملاء</option>
                                            @foreach($customers as $customer)
                                                <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>
                                                    {{ $customer->id }} - {{ $customer->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="customer_name">اسم العميل</label>
                                        <input type="text" name="customer_name" id="customer_name" class="form-control" value="{{ request('customer_name') }}" placeholder="ادخل اسم العميل">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="from_date">من تاريخ</label>
                                        <input type="date" name="from_date" id="from_date" class="form-control" value="{{ request('from_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="to_date">إلى تاريخ</label>
                                        <input type="date" name="to_date" id="to_date" class="form-control" value="{{ request('to_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="submit" class="btn btn-primary btn-block">تطبيق الفلتر</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">تقرير انتهاء ضمان المصاعد</h3>
                        <div class="card-tools">
                            <button class="btn btn-sm btn-success" onclick="exportToExcel()">
                                <i class="fas fa-file-excel"></i> تصدير إلى Excel
                            </button>
                            <button class="btn btn-sm btn-danger" onclick="printReport()">
                                <i class="fas fa-print"></i> طباعة
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="warranty-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>مسلسل</th>
                                        <th>رقم المصعد</th>
                                        <th>اسم العميل</th>
                                        <th>تاريخ انتهاء الصيانة المجانية</th>
                                        <th>تاريخ انتهاء الضمان</th>
                                        <th>تاريخ انتهاء ضمان الكنترول</th>
                                        <th>تاريخ انتهاء ضمان الماكينة</th>
                                        <th>حالة المصعد</th>
                                        <th>التفاصيل</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($elevators as $index => $elevator)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $elevator->serial_number }}</td>
                                        <td>{{ $elevator->customer_name }}</td>
                                        <td>
                                            @if($elevator->free_maintenance_end_date)
                                                {{ date('Y-m-d', strtotime($elevator->free_maintenance_end_date)) }}
                                                @if(now() > $elevator->free_maintenance_end_date)
                                                    <span class="badge badge-danger">منتهي</span>
                                                @else
                                                    <span class="badge badge-success">ساري</span>
                                                @endif
                                            @else
                                                <span class="text-muted">غير محدد</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($elevator->warranty_end_date)
                                                {{ date('Y-m-d', strtotime($elevator->warranty_end_date)) }}
                                                @if(now() > $elevator->warranty_end_date)
                                                    <span class="badge badge-danger">منتهي</span>
                                                @else
                                                    <span class="badge badge-success">ساري</span>
                                                @endif
                                            @else
                                                <span class="text-muted">غير محدد</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($elevator->control_warranty_end_date)
                                                {{ date('Y-m-d', strtotime($elevator->control_warranty_end_date)) }}
                                                @if(now() > $elevator->control_warranty_end_date)
                                                    <span class="badge badge-danger">منتهي</span>
                                                @else
                                                    <span class="badge badge-success">ساري</span>
                                                @endif
                                            @else
                                                <span class="text-muted">غير محدد</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($elevator->machine_warranty_end_date)
                                                {{ date('Y-m-d', strtotime($elevator->machine_warranty_end_date)) }}
                                                @if(now() > $elevator->machine_warranty_end_date)
                                                    <span class="badge badge-danger">منتهي</span>
                                                @else
                                                    <span class="badge badge-success">ساري</span>
                                                @endif
                                            @else
                                                <span class="text-muted">غير محدد</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($elevator->status == 'active')
                                                <span class="badge badge-success">نشط</span>
                                            @elseif($elevator->status == 'inactive')
                                                <span class="badge badge-warning">غير نشط</span>
                                            @elseif($elevator->status == 'maintenance')
                                                <span class="badge badge-info">قيد الصيانة</span>
                                            @elseif($elevator->status == 'out_of_service')
                                                <span class="badge badge-danger">خارج الخدمة</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $elevator->status }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('elevators.show', $elevator->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/tableExport.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF/jspdf.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js"></script>
<script>
    $(function () {
        $('#warranty-table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            }
        });
    });
    
    function exportToExcel() {
        $('#warranty-table').tableExport({
            headers: true,
            footers: true,
            formats: ['xlsx'],
            filename: 'تقرير_انتهاء_ضمان_المصاعد',
            bootstrap: true,
            exportButtons: false,
            position: 'bottom',
            ignoreRows: null,
            ignoreCols: null,
            trimWhitespace: true,
            RTL: true,
            sheetname: 'تقرير انتهاء ضمان المصاعد'
        });
    }
    
    function printReport() {
        window.print();
    }
</script>
@endsection