@extends('layouts.app')

@section('title', 'تقرير الصيانة الدورية')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">تقرير الصيانة الدورية</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('elevator-reports.index') }}">تقارير المصاعد</a></li>
                    <li class="breadcrumb-item active">تقرير الصيانة الدورية</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">فلترة التقرير</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('elevator-reports.maintenance') }}" method="GET" class="mb-4">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="status">الحالة</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="">جميع الحالات</option>
                                            <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>قيد الانتظار</option>
                                            <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتملة</option>
                                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغية</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="from_date">من تاريخ</label>
                                        <input type="date" name="from_date" id="from_date" class="form-control" value="{{ request('from_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="to_date">إلى تاريخ</label>
                                        <input type="date" name="to_date" id="to_date" class="form-control" value="{{ request('to_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="submit" class="btn btn-primary btn-block">تطبيق الفلتر</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">تقرير الصيانة الدورية</h3>
                        <div class="card-tools">
                            <button class="btn btn-sm btn-success" onclick="exportToExcel()">
                                <i class="fas fa-file-excel"></i> تصدير إلى Excel
                            </button>
                            <button class="btn btn-sm btn-danger" onclick="printReport()">
                                <i class="fas fa-print"></i> طباعة
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="maintenance-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>رقم المصعد</th>
                                        <th>العميل</th>
                                        <th>المبنى</th>
                                        <th>تاريخ الصيانة</th>
                                        <th>نوع الصيانة</th>
                                        <th>الحالة</th>
                                        <th>الفني المسؤول</th>
                                        <th>ملاحظات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($maintenances as $index => $maintenance)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $maintenance->serial_number }}</td>
                                        <td>{{ $maintenance->customer_name }}</td>
                                        <td>{{ $maintenance->building_name }}</td>
                                        <td>{{ date('Y-m-d', strtotime($maintenance->maintenance_date)) }}</td>
                                        <td>
                                            @if($maintenance->maintenance_type == 'routine')
                                                صيانة دورية
                                            @elseif($maintenance->maintenance_type == 'emergency')
                                                صيانة طارئة
                                            @elseif($maintenance->maintenance_type == 'preventive')
                                                صيانة وقائية
                                            @else
                                                {{ $maintenance->maintenance_type }}
                                            @endif
                                        </td>
                                        <td>
                                            @if($maintenance->status == 'scheduled')
                                                <span class="badge badge-warning">قيد الانتظار</span>
                                            @elseif($maintenance->status == 'in_progress')
                                                <span class="badge badge-info">قيد التنفيذ</span>
                                            @elseif($maintenance->status == 'completed')
                                                <span class="badge badge-success">مكتملة</span>
                                            @elseif($maintenance->status == 'cancelled')
                                                <span class="badge badge-danger">ملغية</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $maintenance->status }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $maintenance->technician ? $maintenance->technician->name : 'غير محدد' }}</td>
                                        <td>{{ $maintenance->notes ?? 'لا توجد ملاحظات' }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/tableExport.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF/jspdf.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js"></script>
<script>
    $(function () {
        $('#maintenance-table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            }
        });
    });
    
    function exportToExcel() {
        $('#maintenance-table').tableExport({
            headers: true,
            footers: true,
            formats: ['xlsx'],
            filename: 'تقرير_الصيانة_الدورية',
            bootstrap: true,
            exportButtons: false,
            position: 'bottom',
            ignoreRows: null,
            ignoreCols: null,
            trimWhitespace: true,
            RTL: true,
            sheetname: 'تقرير الصيانة الدورية'
        });
    }
    
    function printReport() {
        window.print();
    }
</script>
@endsection