@extends('layouts.app')

@section('title', 'تقرير كل مصاعد الصيانة')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">تقرير كل مصاعد الصيانة</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('elevator-reports.index') }}">تقارير المصاعد</a></li>
                    <li class="breadcrumb-item active">تقرير كل مصاعد الصيانة</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">مصاعد الصيانة</h3>
                        <div class="card-tools">
                            <button class="btn btn-sm btn-success" onclick="exportToExcel()">
                                <i class="fas fa-file-excel"></i> تصدير إلى Excel
                            </button>
                            <button class="btn btn-sm btn-danger" onclick="printReport()">
                                <i class="fas fa-print"></i> طباعة
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- فلتر البحث -->
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <form method="GET" action="{{ route('elevator-reports.maintenance-elevators') }}" class="form-inline">
                                    <div class="form-group mx-2">
                                        <input type="text" name="search" class="form-control" placeholder="بحث باسم العميل أو رقم المصعد أو رقم الجوال" value="{{ request('search') }}">
                                    </div>
                                    <div class="form-group mx-2">
                                        <select name="status" class="form-control">
                                            <option value="">-- كل الحالات --</option>
                                            @foreach($elevatorStatuses as $key => $status)
                                                <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>{{ $status }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <button type="submit" class="btn btn-primary mx-2">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                    <a href="{{ route('elevator-reports.maintenance-elevators') }}" class="btn btn-secondary">
                                        <i class="fas fa-redo"></i> إعادة تعيين
                                    </a>
                                </form>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table id="maintenance-elevators-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>رقم المصعد</th>
                                        <th>حالة المصعد</th>
                                        <th>الموقع</th>
                                        <th>اسم العميل</th>
                                        <th>رقم الجوال</th>
                                        <th>تاريخ نهاية العقد</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($elevators as $index => $elevator)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $elevator->serial_number }}</td>
                                        <td>
                                            @if($elevator->elevator_status == 'active')
                                                <span class="badge badge-success">{{ $elevator->elevator_status_name }}</span>
                                            @elseif($elevator->elevator_status == 'inactive')
                                                <span class="badge badge-danger">{{ $elevator->elevator_status_name }}</span>
                                            @elseif($elevator->elevator_status == 'maintenance')
                                                <span class="badge badge-warning">{{ $elevator->elevator_status_name }}</span>
                                            @elseif($elevator->elevator_status == 'out_of_service')
                                                <span class="badge badge-secondary">{{ $elevator->elevator_status_name }}</span>
                                            @elseif($elevator->elevator_status == 'under_repair')
                                                <span class="badge badge-info">{{ $elevator->elevator_status_name }}</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $elevator->elevator_status_name }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            {{ $elevator->location_name }}
                                            @if($elevator->latitude && $elevator->longitude)
                                                <a href="https://www.google.com/maps?q={{ $elevator->latitude }},{{ $elevator->longitude }}" target="_blank" class="btn btn-sm btn-danger map-btn">
                                                    <i class="fas fa-map-marker-alt"></i> عرض الخريطة
                                                </a>
                                            @else
                                                <span class="badge badge-warning location-warning">
                                                    <i class="fas fa-exclamation-triangle"></i> لا توجد إحداثيات
                                                </span>
                                            @endif
                                        </td>
                                        <td>{{ $elevator->customer_name }}</td>
                                        <td>
                                            @if($elevator->customer_mobile)
                                                <a href="tel:{{ $elevator->customer_mobile }}" class="phone-link">
                                                    {{ $elevator->customer_mobile }} <i class="fas fa-phone-alt text-success"></i>
                                                </a>
                                            @else
                                                غير متوفر
                                            @endif
                                        </td>
                                        <td>
                                            @if(strtotime($elevator->contract_end_date) < strtotime('+30 days'))
                                                <span class="text-danger font-weight-bold">{{ date('Y-m-d', strtotime($elevator->contract_end_date)) }}</span>
                                            @else
                                                {{ date('Y-m-d', strtotime($elevator->contract_end_date)) }}
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .phone-link {
        color: #28a745;
        text-decoration: none;
    }
    .phone-link:hover {
        text-decoration: underline;
    }
    
    /* تنسيق زر الخريطة */
    .map-btn {
        margin-right: 5px;
        margin-top: 3px;
        display: inline-block;
    }
    
    /* تنسيق رسالة تحذير عدم وجود إحداثيات */
    .location-warning {
        margin-right: 5px;
        margin-top: 3px;
        display: inline-block;
        background-color: #ffc107;
        color: #000;
        font-size: 12px;
    }
    
    @media print {
        .no-print {
            display: none !important;
        }
        .card-tools, form, .main-header, .main-sidebar, .main-footer, .map-btn, .location-warning {
            display: none !important;
        }
        a[href]:after {
            content: none !important;
        }
    }
</style>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/tableExport.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF/jspdf.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js"></script>
<script>
    $(function () {
        $('#maintenance-elevators-table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            }
        });
        
        // لا نحتاج إلى أي كود JavaScript إضافي للخريطة بعد التبسيط
    });
    
    function exportToExcel() {
        $('#maintenance-elevators-table').tableExport({
            headers: true,
            footers: true,
            formats: ['xlsx'],
            filename: 'تقرير_مصاعد_الصيانة',
            bootstrap: true,
            exportButtons: false,
            position: 'bottom',
            ignoreRows: null,
            ignoreCols: null,
            trimWhitespace: true,
            RTL: true,
            sheetname: 'تقرير مصاعد الصيانة'
        });
    }
    
    function printReport() {
        window.print();
    }
</script>
@endsection