@extends('layouts.app')

@section('title', 'تقرير عمليات الفحص')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">تقرير عمليات الفحص</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('elevator-reports.index') }}">تقارير المصاعد</a></li>
                    <li class="breadcrumb-item active">تقرير عمليات الفحص</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">فلترة التقرير</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('elevator-reports.inspection') }}" method="GET" class="mb-4">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="inspection_type">نوع الفحص</label>
                                        <select name="inspection_type" id="inspection_type" class="form-control">
                                            <option value="">جميع الأنواع</option>
                                            <option value="routine" {{ request('inspection_type') == 'routine' ? 'selected' : '' }}>فحص روتيني</option>
                                            <option value="safety" {{ request('inspection_type') == 'safety' ? 'selected' : '' }}>فحص سلامة</option>
                                            <option value="certification" {{ request('inspection_type') == 'certification' ? 'selected' : '' }}>فحص شهادة</option>
                                            <option value="complaint" {{ request('inspection_type') == 'complaint' ? 'selected' : '' }}>فحص شكوى</option>
                                            <option value="other" {{ request('inspection_type') == 'other' ? 'selected' : '' }}>فحص آخر</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="status">الحالة</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="">جميع الحالات</option>
                                            <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>مجدول</option>
                                            <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="from_date">من تاريخ</label>
                                        <input type="date" name="from_date" id="from_date" class="form-control" value="{{ request('from_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="to_date">إلى تاريخ</label>
                                        <input type="date" name="to_date" id="to_date" class="form-control" value="{{ request('to_date') }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label>&nbsp;</label>
                                        <button type="submit" class="btn btn-primary btn-block">تطبيق الفلتر</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">تقرير عمليات الفحص</h3>
                        <div class="card-tools">
                            <button class="btn btn-sm btn-success" onclick="exportToExcel()">
                                <i class="fas fa-file-excel"></i> تصدير إلى Excel
                            </button>
                            <button class="btn btn-sm btn-danger" onclick="printReport()">
                                <i class="fas fa-print"></i> طباعة
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="inspection-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>رقم المصعد</th>
                                        <th>العميل</th>
                                        <th>المبنى</th>
                                        <th>تاريخ الفحص</th>
                                        <th>نوع الفحص</th>
                                        <th>الحالة</th>
                                        <th>الفني المسؤول</th>
                                        <th>نتيجة الفحص</th>
                                        <th>رقم الشهادة</th>
                                        <th>تاريخ انتهاء الشهادة</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($inspections as $index => $inspection)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $inspection->serial_number }}</td>
                                        <td>{{ $inspection->customer_name }}</td>
                                        <td>{{ $inspection->building_name }}</td>
                                        <td>{{ date('Y-m-d', strtotime($inspection->inspection_date)) }}</td>
                                        <td>{{ $inspection->getInspectionTypeName() }}</td>
                                        <td>
                                            @if($inspection->status == 'scheduled')
                                                <span class="badge badge-warning">مجدول</span>
                                            @elseif($inspection->status == 'in_progress')
                                                <span class="badge badge-info">قيد التنفيذ</span>
                                            @elseif($inspection->status == 'completed')
                                                <span class="badge badge-success">مكتمل</span>
                                            @elseif($inspection->status == 'cancelled')
                                                <span class="badge badge-danger">ملغي</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $inspection->status }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $inspection->technician ? $inspection->technician->name : 'غير محدد' }}</td>
                                        <td>
                                            @if($inspection->passed === null)
                                                <span class="badge badge-secondary">غير محدد</span>
                                            @elseif($inspection->passed)
                                                <span class="badge badge-success">ناجح</span>
                                            @else
                                                <span class="badge badge-danger">راسب</span>
                                            @endif
                                        </td>
                                        <td>{{ $inspection->certificate_number ?? 'لا يوجد' }}</td>
                                        <td>{{ $inspection->certificate_expiry_date ? date('Y-m-d', strtotime($inspection->certificate_expiry_date)) : 'لا يوجد' }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/tableExport.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF/jspdf.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js"></script>
<script>
    $(function () {
        $('#inspection-table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            }
        });
    });
    
    function exportToExcel() {
        $('#inspection-table').tableExport({
            headers: true,
            footers: true,
            formats: ['xlsx'],
            filename: 'تقرير_عمليات_الفحص',
            bootstrap: true,
            exportButtons: false,
            position: 'bottom',
            ignoreRows: null,
            ignoreCols: null,
            trimWhitespace: true,
            RTL: true,
            sheetname: 'تقرير عمليات الفحص'
        });
    }
    
    function printReport() {
        window.print();
    }
</script>
@endsection