@extends('layouts.app')

@section('title', 'تقارير المصاعد')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">تقارير المصاعد</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item active">تقارير المصاعد</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <!-- إحصائيات عامة -->
        <div class="row">
            <div class="col-lg-4 col-md-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3>{{ $totalElevators }}</h3>
                        <p>إجمالي المصاعد</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-elevator"></i>
                    </div>
                    <a href="{{ route('elevator-reports.elevator-status') }}" class="small-box-footer">
                        تفاصيل أكثر <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
            
            <div class="col-lg-4 col-md-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3>{{ $totalMaintenances }}</h3>
                        <p>عمليات الصيانة</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-tools"></i>
                    </div>
                    <a href="{{ route('elevator-reports.maintenance') }}" class="small-box-footer">
                        تفاصيل أكثر <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
            
            <div class="col-lg-4 col-md-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3>{{ $totalInspections }}</h3>
                        <p>عمليات الفحص</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-clipboard-check"></i>
                    </div>
                    <a href="{{ route('elevator-reports.inspection') }}" class="small-box-footer">
                        تفاصيل أكثر <i class="fas fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>
        
        <!-- روابط التقارير -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">التقارير المتاحة</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 col-sm-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-info"><i class="fas fa-list"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">حالة المصاعد</span>
                                        <a href="{{ route('elevator-reports.elevator-status') }}" class="btn btn-sm btn-info mt-2">عرض التقرير</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-success"><i class="fas fa-tools"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">تقرير الصيانة</span>
                                        <a href="{{ route('elevator-reports.maintenance') }}" class="btn btn-sm btn-success mt-2">عرض التقرير</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-warning"><i class="fas fa-clipboard-check"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">تقرير الفحص</span>
                                        <a href="{{ route('elevator-reports.inspection') }}" class="btn btn-sm btn-warning mt-2">عرض التقرير</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-primary"><i class="fas fa-users"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">المصاعد حسب العميل</span>
                                        <a href="{{ route('elevator-reports.by-customer') }}" class="btn btn-sm btn-primary mt-2">عرض التقرير</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-secondary"><i class="fas fa-tags"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">المصاعد حسب النوع</span>
                                        <a href="{{ route('elevator-reports.by-type') }}" class="btn btn-sm btn-secondary mt-2">عرض التقرير</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-danger"><i class="fas fa-cubes"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">المصاعد حسب الموديل</span>
                                        <a href="{{ route('elevator-reports.by-model') }}" class="btn btn-sm btn-danger mt-2">عرض التقرير</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-purple"><i class="fas fa-file-contract"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">تقرير كل مصاعد الصيانة</span>
                                        <a href="{{ route('elevator-reports.maintenance-elevators') }}" class="btn btn-sm btn-purple mt-2">عرض التقرير</a>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4 col-sm-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-orange"><i class="fas fa-shield-alt"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">تقرير انتهاء ضمان المصاعد</span>
                                        <a href="{{ route('elevator-reports.warranty') }}" class="btn btn-sm btn-warning mt-2">عرض التقرير</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- إحصائيات المصاعد -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">المصاعد حسب النوع</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="elevatorsByTypeChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">المصاعد حسب الموديل</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="elevatorsByModelChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- إحصائيات الصيانة والفحص -->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">حالة عمليات الصيانة</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="maintenanceStatsChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">حالة عمليات الفحص</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="inspectionStatsChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // المصاعد حسب النوع
        var typeCtx = document.getElementById('elevatorsByTypeChart').getContext('2d');
        var typeData = {
            labels: {!! json_encode($elevatorsByType->pluck('name')) !!},
            datasets: [{
                label: 'عدد المصاعد',
                data: {!! json_encode($elevatorsByType->pluck('total')) !!},
                backgroundColor: [
                    'rgba(54, 162, 235, 0.6)',
                    'rgba(255, 99, 132, 0.6)',
                    'rgba(255, 206, 86, 0.6)',
                    'rgba(75, 192, 192, 0.6)',
                    'rgba(153, 102, 255, 0.6)',
                    'rgba(255, 159, 64, 0.6)'
                ],
                borderColor: [
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 99, 132, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)'
                ],
                borderWidth: 1
            }]
        };
        new Chart(typeCtx, {
            type: 'pie',
            data: typeData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });
        
        // المصاعد حسب الموديل
        var modelCtx = document.getElementById('elevatorsByModelChart').getContext('2d');
        var modelData = {
            labels: {!! json_encode($elevatorsByModel->pluck('name')) !!},
            datasets: [{
                label: 'عدد المصاعد',
                data: {!! json_encode($elevatorsByModel->pluck('total')) !!},
                backgroundColor: [
                    'rgba(255, 99, 132, 0.6)',
                    'rgba(54, 162, 235, 0.6)',
                    'rgba(255, 206, 86, 0.6)',
                    'rgba(75, 192, 192, 0.6)',
                    'rgba(153, 102, 255, 0.6)',
                    'rgba(255, 159, 64, 0.6)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)'
                ],
                borderWidth: 1
            }]
        };
        new Chart(modelCtx, {
            type: 'pie',
            data: modelData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });
        
        // حالة عمليات الصيانة
        var maintenanceCtx = document.getElementById('maintenanceStatsChart').getContext('2d');
        var maintenanceData = {
            labels: ['قيد الانتظار', 'قيد التنفيذ', 'مكتملة', 'ملغية'],
            datasets: [{
                label: 'عدد العمليات',
                data: [
                    {{ $maintenanceStats['scheduled'] ?? 0 }},
                    {{ $maintenanceStats['in_progress'] ?? 0 }},
                    {{ $maintenanceStats['completed'] ?? 0 }},
                    {{ $maintenanceStats['cancelled'] ?? 0 }}
                ],
                backgroundColor: [
                    'rgba(255, 206, 86, 0.6)',
                    'rgba(54, 162, 235, 0.6)',
                    'rgba(75, 192, 192, 0.6)',
                    'rgba(255, 99, 132, 0.6)'
                ],
                borderColor: [
                    'rgba(255, 206, 86, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(255, 99, 132, 1)'
                ],
                borderWidth: 1
            }]
        };
        new Chart(maintenanceCtx, {
            type: 'doughnut',
            data: maintenanceData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });
        
        // حالة عمليات الفحص
        var inspectionCtx = document.getElementById('inspectionStatsChart').getContext('2d');
        var inspectionData = {
            labels: ['مجدول', 'قيد التنفيذ', 'مكتمل', 'ملغي'],
            datasets: [{
                label: 'عدد العمليات',
                data: [
                    {{ $inspectionStats['scheduled'] ?? 0 }},
                    {{ $inspectionStats['in_progress'] ?? 0 }},
                    {{ $inspectionStats['completed'] ?? 0 }},
                    {{ $inspectionStats['cancelled'] ?? 0 }}
                ],
                backgroundColor: [
                    'rgba(255, 206, 86, 0.6)',
                    'rgba(54, 162, 235, 0.6)',
                    'rgba(75, 192, 192, 0.6)',
                    'rgba(255, 99, 132, 0.6)'
                ],
                borderColor: [
                    'rgba(255, 206, 86, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(255, 99, 132, 1)'
                ],
                borderWidth: 1
            }]
        };
        new Chart(inspectionCtx, {
            type: 'doughnut',
            data: inspectionData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });
    });
</script>
@endsection