@extends('layouts.app')

@section('title', 'تقرير المصاعد حسب الموديل')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">تقرير المصاعد حسب الموديل</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('elevator-reports.index') }}">تقارير المصاعد</a></li>
                    <li class="breadcrumb-item active">تقرير المصاعد حسب الموديل</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">المصاعد حسب الموديل</h3>
                        <div class="card-tools">
                            <button class="btn btn-sm btn-success" onclick="exportToExcel()">
                                <i class="fas fa-file-excel"></i> تصدير إلى Excel
                            </button>
                            <button class="btn btn-sm btn-danger" onclick="printReport()">
                                <i class="fas fa-print"></i> طباعة
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="models-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>اسم الموديل</th>
                                        <th>الشركة المصنعة</th>
                                        <th>الوصف</th>
                                        <th>عدد المصاعد</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($models as $index => $model)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $model->name }}</td>
                                        <td>{{ $model->manufacturer }}</td>
                                        <td>{{ $model->description }}</td>
                                        <td>{{ $model->elevators_count }}</td>
                                        <td>
                                            <a href="{{ url('/elevator-models/' . $model->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i> عرض التفاصيل
                                            </a>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">رسم بياني للمصاعد حسب الموديل</h3>
                    </div>
                    <div class="card-body">
                        <canvas id="modelChart" style="min-height: 400px; height: 400px; max-height: 400px; max-width: 100%;"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/tableExport.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF/jspdf.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js"></script>
<script>
    $(function () {
        $('#models-table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            }
        });
        
        // رسم بياني للمصاعد حسب الموديل
        var ctx = document.getElementById('modelChart').getContext('2d');
        var modelData = {
            labels: {!! json_encode($models->pluck('name')) !!},
            datasets: [{
                label: 'عدد المصاعد',
                data: {!! json_encode($models->pluck('elevators_count')) !!},
                backgroundColor: [
                    'rgba(255, 99, 132, 0.6)',
                    'rgba(54, 162, 235, 0.6)',
                    'rgba(255, 206, 86, 0.6)',
                    'rgba(75, 192, 192, 0.6)',
                    'rgba(153, 102, 255, 0.6)',
                    'rgba(255, 159, 64, 0.6)',
                    'rgba(201, 203, 207, 0.6)',
                    'rgba(255, 99, 71, 0.6)',
                    'rgba(46, 139, 87, 0.6)',
                    'rgba(106, 90, 205, 0.6)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(201, 203, 207, 1)',
                    'rgba(255, 99, 71, 1)',
                    'rgba(46, 139, 87, 1)',
                    'rgba(106, 90, 205, 1)'
                ],
                borderWidth: 1
            }]
        };
        
        new Chart(ctx, {
            type: 'doughnut',
            data: modelData,
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                    }
                }
            }
        });
    });
    
    function exportToExcel() {
        $('#models-table').tableExport({
            headers: true,
            footers: true,
            formats: ['xlsx'],
            filename: 'تقرير_المصاعد_حسب_الموديل',
            bootstrap: true,
            exportButtons: false,
            position: 'bottom',
            ignoreRows: null,
            ignoreCols: null,
            trimWhitespace: true,
            RTL: true,
            sheetname: 'تقرير المصاعد حسب الموديل'
        });
    }
    
    function printReport() {
        window.print();
    }
</script>
@endsection