@extends('layouts.app')

@section('title', 'تقرير حالة المصاعد')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">تقرير حالة المصاعد</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('elevator-reports.index') }}">تقارير المصاعد</a></li>
                    <li class="breadcrumb-item active">تقرير حالة المصاعد</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">حالة المصاعد</h3>
                        <div class="card-tools">
                            <button class="btn btn-sm btn-success" onclick="exportToExcel()">
                                <i class="fas fa-file-excel"></i> تصدير إلى Excel
                            </button>
                            <button class="btn btn-sm btn-danger" onclick="printReport()">
                                <i class="fas fa-print"></i> طباعة
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="elevators-table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الرقم التسلسلي</th>
                                        <th>العميل</th>
                                        <th>اسم المبنى</th>
                                        <th>العنوان</th>
                                        <th>النوع</th>
                                        <th>الموديل</th>
                                        <th>سنة التركيب</th>
                                        <th>الحالة</th>
                                        <th>آخر صيانة</th>
                                        <th>آخر فحص</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($elevators as $index => $elevator)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $elevator->serial_number }}</td>
                                        <td>{{ $elevator->customer_name }}</td>
                                        <td>{{ $elevator->building_name }}</td>
                                        <td>{{ $elevator->address }}</td>
                                        <td>{{ $elevator->type_name }}</td>
                                        <td>{{ $elevator->model_name }}</td>
                                        <td>{{ $elevator->installation_date ? date('Y', strtotime($elevator->installation_date)) : 'غير محدد' }}</td>
                                        <td>
                                            @if($elevator->status == 'active')
                                                <span class="badge badge-success">نشط</span>
                                            @elseif($elevator->status == 'inactive')
                                                <span class="badge badge-danger">غير نشط</span>
                                            @elseif($elevator->status == 'maintenance')
                                                <span class="badge badge-warning">قيد الصيانة</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $elevator->status }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $elevator->last_maintenance_date ? date('Y-m-d', strtotime($elevator->last_maintenance_date)) : 'لا يوجد' }}</td>
                                        <td>{{ $elevator->last_inspection_date ? date('Y-m-d', strtotime($elevator->last_inspection_date)) : 'لا يوجد' }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/tableExport.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF/jspdf.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/tableexport.jquery.plugin@1.10.21/libs/jsPDF-AutoTable/jspdf.plugin.autotable.js"></script>
<script>
    $(function () {
        $('#elevators-table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            }
        });
    });
    
    function exportToExcel() {
        $('#elevators-table').tableExport({
            headers: true,
            footers: true,
            formats: ['xlsx'],
            filename: 'تقرير_حالة_المصاعد',
            bootstrap: true,
            exportButtons: false,
            position: 'bottom',
            ignoreRows: null,
            ignoreCols: null,
            trimWhitespace: true,
            RTL: true,
            sheetname: 'تقرير حالة المصاعد'
        });
    }
    
    function printReport() {
        window.print();
    }
</script>
@endsection