@extends('layouts.app')

@section('title', 'تفاصيل قطعة الغيار')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل قطعة الغيار: {{ $elevatorPart->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-parts.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>الاسم:</label>
                                <p class="form-control">{{ $elevatorPart->name }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>رقم القطعة:</label>
                                <p class="form-control">{{ $elevatorPart->part_number ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>الشركة المصنعة:</label>
                                <p class="form-control">{{ $elevatorPart->manufacturer ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>الموديل:</label>
                                <p class="form-control">{{ $elevatorPart->model ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>سعر التكلفة:</label>
                                <p class="form-control">{{ $elevatorPart->cost_price ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>سعر البيع:</label>
                                <p class="form-control">{{ $elevatorPart->selling_price ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>المخزون الحالي:</label>
                                <p class="form-control">{{ $elevatorPart->current_stock }} {{ $elevatorPart->unit ?? 'قطعة' }}</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>الحد الأدنى للمخزون:</label>
                                <p class="form-control">{{ $elevatorPart->min_stock_level }} {{ $elevatorPart->unit ?? 'قطعة' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>حالة المخزون:</label>
                                <p class="form-control">
                                    @if($elevatorPart->current_stock <= 0)
                                        <span class="badge badge-danger">نفذ</span>
                                    @elseif($elevatorPart->isLowStock())
                                        <span class="badge badge-warning">منخفض</span>
                                    @else
                                        <span class="badge badge-success">متوفر</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>موقع التخزين:</label>
                                <p class="form-control">{{ $elevatorPart->location ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>الحالة:</label>
                                <p class="form-control">
                                    @if($elevatorPart->is_active)
                                        <span class="badge badge-success">نشط</span>
                                    @else
                                        <span class="badge badge-danger">غير نشط</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>المواصفات الفنية:</label>
                                <p class="form-control" style="min-height: 100px;">{{ $elevatorPart->specifications ?? 'لا توجد مواصفات فنية' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>الوصف:</label>
                                <p class="form-control" style="min-height: 100px;">{{ $elevatorPart->description ?? 'لا يوجد وصف' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    <div class="btn-group">
                        <a href="{{ route('elevator-parts.edit', $elevatorPart->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('elevator-parts.edit-stock', $elevatorPart->id) }}" class="btn btn-primary">
                            <i class="fas fa-boxes"></i> تعديل المخزون
                        </a>
                        <form action="{{ route('elevator-parts.destroy', $elevatorPart->id) }}" method="POST" style="display: inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه القطعة؟')">
                                <i class="fas fa-trash"></i> حذف
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection