@extends('layouts.app')

@section('title', 'قطع غيار منخفضة المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">قطع غيار منخفضة المخزون</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-parts.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>الاسم</th>
                                <th>رقم القطعة</th>
                                <th>المخزون الحالي</th>
                                <th>الحد الأدنى</th>
                                <th>حالة المخزون</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($elevatorParts as $index => $part)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $part->name }}</td>
                                    <td>{{ $part->part_number ?? 'غير محدد' }}</td>
                                    <td>{{ $part->current_stock }} {{ $part->unit ?? 'قطعة' }}</td>
                                    <td>{{ $part->min_stock_level }} {{ $part->unit ?? 'قطعة' }}</td>
                                    <td>
                                        @if($part->current_stock <= 0)
                                            <span class="badge badge-danger">نفذ</span>
                                        @elseif($part->isLowStock())
                                            <span class="badge badge-warning">منخفض</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('elevator-parts.show', $part->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('elevator-parts.edit-stock', $part->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-boxes"></i> تعديل المخزون
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد قطع غيار منخفضة المخزون</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $elevatorParts->links() }}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection