@extends('layouts.app')

@section('title', 'قطع غيار المصاعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قطع غيار المصاعد</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-parts.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة قطعة غيار جديدة
                        </a>
                        <a href="{{ route('elevator-parts.low-stock') }}" class="btn btn-sm btn-warning">
                            <i class="fas fa-exclamation-triangle"></i> المخزون المنخفض
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-ban"></i> خطأ!</h5>
                            {{ session('error') }}
                        </div>
                    @endif

                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>الاسم</th>
                                <th>رقم القطعة</th>
                                <th>الشركة المصنعة</th>
                                <th>المخزون الحالي</th>
                                <th>الحد الأدنى</th>
                                <th>حالة المخزون</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($elevatorParts as $index => $part)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $part->name }}</td>
                                    <td>{{ $part->part_number ?? 'غير محدد' }}</td>
                                    <td>{{ $part->manufacturer ?? 'غير محدد' }}</td>
                                    <td>{{ $part->current_stock }} {{ $part->unit ?? 'قطعة' }}</td>
                                    <td>{{ $part->min_stock_level }} {{ $part->unit ?? 'قطعة' }}</td>
                                    <td>
                                        @if($part->current_stock <= 0)
                                            <span class="badge badge-danger">نفذ</span>
                                        @elseif($part->isLowStock())
                                            <span class="badge badge-warning">منخفض</span>
                                        @else
                                            <span class="badge badge-success">متوفر</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($part->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('elevator-parts.show', $part->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('elevator-parts.edit', $part->id) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="{{ route('elevator-parts.edit-stock', $part->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-boxes"></i>
                                        </a>
                                        <form action="{{ route('elevator-parts.destroy', $part->id) }}" method="POST" style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه القطعة؟')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد قطع غيار مسجلة</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $elevatorParts->links() }}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection