@extends('layouts.app')

@section('title', 'تعديل مخزون قطعة غيار')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">تعديل مخزون قطعة غيار: {{ $elevatorPart->name }}</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="POST" action="{{ route('elevator-parts.update-stock', $elevatorPart->id) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>اسم قطعة الغيار:</label>
                                    <p class="form-control">{{ $elevatorPart->name }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>رقم القطعة:</label>
                                    <p class="form-control">{{ $elevatorPart->part_number ?? 'غير محدد' }}</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="current_stock">المخزون الحالي <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control @error('current_stock') is-invalid @enderror" id="current_stock" name="current_stock" value="{{ old('current_stock', $elevatorPart->current_stock) }}" required placeholder="أدخل المخزون الحالي">
                                    @error('current_stock')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="min_stock_level">الحد الأدنى للمخزون <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control @error('min_stock_level') is-invalid @enderror" id="min_stock_level" name="min_stock_level" value="{{ old('min_stock_level', $elevatorPart->min_stock_level) }}" required placeholder="أدخل الحد الأدنى للمخزون">
                                    @error('min_stock_level')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3" placeholder="أدخل ملاحظات حول تغيير المخزون (اختياري)">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">تحديث المخزون</button>
                        <a href="{{ route('elevator-parts.show', $elevatorPart->id) }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection