@extends('layouts.app')

@section('title', 'تفاصيل موديل المصعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل موديل المصعد: {{ $elevatorModel->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-models.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>الاسم:</label>
                                <p class="form-control">{{ $elevatorModel->name }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>الكود:</label>
                                <p class="form-control">{{ $elevatorModel->code ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>نوع المصعد:</label>
                                <p class="form-control">{{ $elevatorModel->type->name ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>الشركة المصنعة:</label>
                                <p class="form-control">{{ $elevatorModel->manufacturer ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>الوزن الأقصى (كجم):</label>
                                <p class="form-control">{{ $elevatorModel->max_weight ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>الحد الأقصى للأشخاص:</label>
                                <p class="form-control">{{ $elevatorModel->max_persons ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>السرعة (م/ث):</label>
                                <p class="form-control">{{ $elevatorModel->speed ?? 'غير محدد' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>الحالة:</label>
                                <p class="form-control">
                                    @if($elevatorModel->is_active)
                                        <span class="badge badge-success">نشط</span>
                                    @else
                                        <span class="badge badge-danger">غير نشط</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>تاريخ الإنشاء:</label>
                                <p class="form-control">{{ $elevatorModel->created_at->format('Y-m-d H:i') }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>المواصفات الفنية:</label>
                                <p class="form-control" style="min-height: 100px;">{{ $elevatorModel->specifications ?? 'لا توجد مواصفات فنية' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>الوصف:</label>
                                <p class="form-control" style="min-height: 100px;">{{ $elevatorModel->description ?? 'لا يوجد وصف' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    <div class="btn-group">
                        <a href="{{ route('elevator-models.edit', $elevatorModel->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <form action="{{ route('elevator-models.destroy', $elevatorModel->id) }}" method="POST" style="display: inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا الموديل؟')">
                                <i class="fas fa-trash"></i> حذف
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection