@extends('layouts.app')

@section('title', 'تعديل موديل المصعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">تعديل موديل المصعد: {{ $elevatorModel->name }}</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="POST" action="{{ route('elevator-models.update', $elevatorModel->id) }}">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">اسم الموديل <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $elevatorModel->name) }}" required placeholder="أدخل اسم موديل المصعد">
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="code">الكود</label>
                                    <input type="text" class="form-control @error('code') is-invalid @enderror" id="code" name="code" value="{{ old('code', $elevatorModel->code) }}" placeholder="أدخل كود موديل المصعد (اختياري)">
                                    @error('code')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="type_id">نوع المصعد</label>
                                    <select class="form-control @error('type_id') is-invalid @enderror" id="type_id" name="type_id">
                                        <option value="">-- اختر نوع المصعد --</option>
                                        @foreach($elevatorTypes as $id => $name)
                                            <option value="{{ $id }}" {{ old('type_id', $elevatorModel->type_id) == $id ? 'selected' : '' }}>{{ $name }}</option>
                                        @endforeach
                                    </select>
                                    @error('type_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="manufacturer">الشركة المصنعة</label>
                                    <input type="text" class="form-control @error('manufacturer') is-invalid @enderror" id="manufacturer" name="manufacturer" value="{{ old('manufacturer', $elevatorModel->manufacturer) }}" placeholder="أدخل اسم الشركة المصنعة (اختياري)">
                                    @error('manufacturer')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="max_weight">الوزن الأقصى (كجم)</label>
                                    <input type="number" class="form-control @error('max_weight') is-invalid @enderror" id="max_weight" name="max_weight" value="{{ old('max_weight', $elevatorModel->max_weight) }}" placeholder="أدخل الوزن الأقصى بالكيلوجرام">
                                    @error('max_weight')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="max_persons">الحد الأقصى للأشخاص</label>
                                    <input type="number" class="form-control @error('max_persons') is-invalid @enderror" id="max_persons" name="max_persons" value="{{ old('max_persons', $elevatorModel->max_persons) }}" placeholder="أدخل الحد الأقصى لعدد الأشخاص">
                                    @error('max_persons')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="speed">السرعة (م/ث)</label>
                                    <input type="number" class="form-control @error('speed') is-invalid @enderror" id="speed" name="speed" value="{{ old('speed', $elevatorModel->speed) }}" placeholder="أدخل السرعة بالمتر/ثانية">
                                    @error('speed')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="specifications">المواصفات الفنية</label>
                            <textarea class="form-control @error('specifications') is-invalid @enderror" id="specifications" name="specifications" rows="3" placeholder="أدخل المواصفات الفنية للموديل (اختياري)">{{ old('specifications', $elevatorModel->specifications) }}</textarea>
                            @error('specifications')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="description">الوصف</label>
                            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" placeholder="أدخل وصف موديل المصعد (اختياري)">{{ old('description', $elevatorModel->description) }}</textarea>
                            @error('description')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', $elevatorModel->is_active) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">نشط</label>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-warning">تحديث</button>
                        <a href="{{ route('elevator-models.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection