@extends('layouts.app')

@section('title', 'تفاصيل عملية الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل عملية الصيانة #{{ $maintenance->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-maintenance.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-elevator"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">المصعد</span>
                                    <span class="info-box-number">
                                        <a href="{{ route('elevators.show', $maintenance->elevator_id) }}">
                                            {{ $maintenance->elevator->name ?? 'غير محدد' }}
                                        </a>
                                    </span>
                                    <span class="info-box-text text-muted">{{ $maintenance->elevator->building_name ?? '' }}</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="info-box">
                                @if($maintenance->maintenance_type == 'corrective' || $maintenance->maintenance_type == 'emergency')
                                    <span class="info-box-icon bg-danger"><i class="fas fa-tools"></i></span>
                                @elseif($maintenance->maintenance_type == 'preventive' || $maintenance->maintenance_type == 'inspection')
                                    <span class="info-box-icon bg-success"><i class="fas fa-tools"></i></span>
                                @else
                                    <span class="info-box-icon bg-warning"><i class="fas fa-tools"></i></span>
                                @endif
                                <div class="info-box-content">
                                    <span class="info-box-text">نوع الصيانة</span>
                                    <span class="info-box-number">
                                        @if($maintenance->maintenance_type == 'corrective')
                                            <span class="badge badge-danger">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'emergency')
                                            <span class="badge badge-danger">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'preventive')
                                            <span class="badge badge-success">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'inspection')
                                            <span class="badge badge-info">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @else
                                            <span class="badge badge-secondary">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @endif
                                    </span>
                                    <span class="info-box-text text-muted">{{ $maintenance->scheduled_date ? $maintenance->scheduled_date->format('Y-m-d') : 'غير محدد' }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-user-cog"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">الفني المسؤول</span>
                                    <span class="info-box-number">{{ $maintenance->technician->name ?? 'غير محدد' }}</span>
                                    <span class="info-box-text text-muted">{{ $maintenance->technician->phone ?? '' }}</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="info-box">
                                <span class="info-box-icon 
                                    @if($maintenance->status == 'pending') bg-warning
                                    @elseif($maintenance->status == 'in_progress') bg-info
                                    @elseif($maintenance->status == 'completed') bg-success
                                    @elseif($maintenance->status == 'cancelled') bg-danger
                                    @else bg-secondary @endif">
                                    <i class="fas fa-tasks"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">الحالة</span>
                                    <span class="info-box-number">
                                        @if($maintenance->status == 'pending')
                                            قيد الانتظار
                                        @elseif($maintenance->status == 'in_progress')
                                            قيد التنفيذ
                                        @elseif($maintenance->status == 'completed')
                                            مكتملة
                                        @elseif($maintenance->status == 'cancelled')
                                            ملغية
                                        @else
                                            {{ $maintenance->status }}
                                        @endif
                                    </span>
                                    <span class="info-box-text text-muted">
                                        الأولوية: 
                                        @if($maintenance->priority == 'low')
                                            <span class="badge badge-secondary">منخفضة</span>
                                        @elseif($maintenance->priority == 'medium')
                                            <span class="badge badge-info">متوسطة</span>
                                        @elseif($maintenance->priority == 'high')
                                            <span class="badge badge-warning">عالية</span>
                                        @elseif($maintenance->priority == 'urgent')
                                            <span class="badge badge-danger">عاجلة</span>
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card card-outline card-primary">
                                <div class="card-header">
                                    <h3 class="card-title">تفاصيل الصيانة</h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>وصف المشكلة / الصيانة:</label>
                                                <p class="form-control" style="min-height: 100px;">{{ $maintenance->description }}</p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>المهام المطلوبة:</label>
                                                <p class="form-control" style="min-height: 100px;">{{ $maintenance->tasks ?? 'لا توجد مهام محددة' }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>الوقت المقدر:</label>
                                                <p class="form-control">{{ $maintenance->estimated_hours }} ساعة</p>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>الوقت الفعلي:</label>
                                                <p class="form-control">{{ $maintenance->actual_hours ?? 'غير محدد' }} ساعة</p>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>التكلفة المقدرة:</label>
                                                <p class="form-control">{{ $maintenance->cost ?? 0 }}</p>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>التكلفة الفعلية:</label>
                                                <p class="form-control">{{ $maintenance->actual_cost ?? 'غير محدد' }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- قطع الغيار المستخدمة -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card card-outline card-warning">
                                <div class="card-header">
                                    <h3 class="card-title">قطع الغيار المستخدمة</h3>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>اسم القطعة</th>
                                                <th>رقم القطعة</th>
                                                <th>الكمية</th>
                                                <th>السعر</th>
                                                <th>الإجمالي</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if(isset($maintenance->parts) && is_iterable($maintenance->parts))
                                                @forelse($maintenance->parts as $index => $part)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $part->name }}</td>
                                                        <td>{{ $part->part_number ?? 'غير محدد' }}</td>
                                                        <td>{{ $part->pivot->quantity ?? 1 }}</td>
                                                        <td>{{ $part->selling_price ?? 0 }}</td>
                                                        <td>{{ ($part->pivot->quantity ?? 1) * ($part->selling_price ?? 0) }}</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="6" class="text-center">لا توجد قطع غيار مستخدمة</td>
                                                    </tr>
                                                @endforelse
                                            @else
                                                <tr>
                                                    <td colspan="6" class="text-center">لا توجد قطع غيار مستخدمة</td>
                                                </tr>
                                            @endif
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th colspan="5" class="text-right">إجمالي تكلفة قطع الغيار:</th>
                                                <th>
                                                    @php
                                                        $totalCost = 0;
                                                        if(isset($maintenance->parts) && is_iterable($maintenance->parts)) {
                                                            foreach($maintenance->parts as $part) {
                                                                $totalCost += ($part->pivot->quantity ?? 1) * ($part->selling_price ?? 0);
                                                            }
                                                        }
                                                        echo $totalCost;
                                                    @endphp
                                                </th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- المرفقات -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card card-outline card-info">
                                <div class="card-header">
                                    <h3 class="card-title">المرفقات</h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        @forelse($maintenance->attachments as $attachment)
                                            <div class="col-md-3">
                                                <div class="attachment-block clearfix">
                                                    <a href="{{ asset('storage/' . $attachment->path) }}" target="_blank">
                                                        @if(in_array(pathinfo($attachment->path, PATHINFO_EXTENSION), ['jpg', 'jpeg', 'png', 'gif']))
                                                            <img class="attachment-img" src="{{ asset('storage/' . $attachment->path) }}" alt="مرفق">
                                                        @else
                                                            <div class="attachment-icon"><i class="fas fa-file"></i></div>
                                                        @endif
                                                        <div class="attachment-pushed">
                                                            <h4 class="attachment-heading">{{ $attachment->name }}</h4>
                                                            <div class="attachment-text">{{ $attachment->created_at->format('Y-m-d') }}</div>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        @empty
                                            <div class="col-md-12">
                                                <p class="text-center">لا توجد مرفقات</p>
                                            </div>
                                        @endforelse
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- ملاحظات الصيانة -->
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card card-outline card-success">
                                <div class="card-header">
                                    <h3 class="card-title">ملاحظات الصيانة</h3>
                                </div>
                                <div class="card-body">
                                    @if($maintenance->notes)
                                        <p>{{ $maintenance->notes }}</p>
                                    @else
                                        <p class="text-center">لا توجد ملاحظات</p>
                                    @endif
                                    
                                    @if($maintenance->status == 'completed')
                                        <div class="alert alert-success">
                                            <h5><i class="icon fas fa-check"></i> تم إكمال الصيانة!</h5>
                                            <p>تاريخ الإكمال: {{ $maintenance->completion_date ? $maintenance->completion_date->format('Y-m-d') : $maintenance->updated_at->format('Y-m-d') }}</p>
                                            @if($maintenance->completion_notes)
                                                <p>ملاحظات الإكمال: {{ $maintenance->completion_notes }}</p>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                    <div class="btn-group">
                        <a href="{{ route('elevator-maintenance.edit', $maintenance->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        
                        @if($maintenance->status != 'completed')
                            <a href="{{ route('elevator-maintenance.complete', $maintenance->id) }}" class="btn btn-success">
                                <i class="fas fa-check"></i> إكمال الصيانة
                            </a>
                        @endif
                        
                        <a href="{{ route('elevator-maintenance.print', $maintenance->id) }}" class="btn btn-primary" target="_blank">
                            <i class="fas fa-print"></i> طباعة
                        </a>
                        
                        <form action="{{ route('elevator-maintenance.destroy', $maintenance->id) }}" method="POST" style="display: inline-block;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه العملية؟')">
                                <i class="fas fa-trash"></i> حذف
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection