@extends('layouts.app')

@section('title', 'عمليات صيانة المصاعد المجدولة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة عمليات صيانة المصاعد المجدولة</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-maintenance.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة عملية صيانة جديدة
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible m-3">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>المصعد</th>
                                <th>نوع الصيانة</th>
                                <th>تاريخ الصيانة</th>
                                <th>الفني المسؤول</th>
                                <th>الأولوية</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($maintenances as $index => $maintenance)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <a href="{{ route('elevators.show', $maintenance->elevator_id) }}">
                                            {{ $maintenance->elevator->name ?? 'غير محدد' }}
                                        </a>
                                    </td>
                                    <td>
                                        @if($maintenance->maintenance_type == 'corrective')
                                            <span class="badge badge-danger">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'emergency')
                                            <span class="badge badge-danger">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'preventive')
                                            <span class="badge badge-success">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'inspection')
                                            <span class="badge badge-info">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @else
                                            <span class="badge badge-secondary">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $maintenance->scheduled_date->format('Y-m-d') }}</td>
                                    <td>{{ $maintenance->technician->name ?? 'غير محدد' }}</td>
                                    <td>
                                        @if($maintenance->priority == 'low')
                                            <span class="badge badge-info">منخفضة</span>
                                        @elseif($maintenance->priority == 'medium')
                                            <span class="badge badge-warning">متوسطة</span>
                                        @elseif($maintenance->priority == 'high')
                                            <span class="badge badge-danger">عالية</span>
                                        @elseif($maintenance->priority == 'urgent')
                                            <span class="badge badge-danger">عاجلة</span>
                                        @else
                                            <span class="badge badge-secondary">{{ $maintenance->priority }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('elevator-maintenance.edit', $maintenance->id) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('elevator-maintenance.complete', $maintenance->id) }}" method="POST" style="display: inline-block;">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('هل أنت متأكد من تحديث حالة الصيانة إلى مكتملة؟')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('elevator-maintenance.cancel', $maintenance->id) }}" method="POST" style="display: inline-block;">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من إلغاء هذه العملية؟')">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد عمليات صيانة مجدولة</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $maintenances->links() }}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection