<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>تقرير صيانة المصعد #{{ $maintenance->id }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f4f6f9;
            margin: 0;
            padding: 0;
        }
        .invoice {
            background-color: #fff;
            border: 1px solid #f4f6f9;
            padding: 20px;
            margin: 10px auto;
            max-width: 800px;
        }
        .invoice-header {
            border-bottom: 1px solid #f4f6f9;
            margin-bottom: 20px;
            padding-bottom: 20px;
        }
        .invoice-title {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 5px;
            color: #17a2b8;
        }
        .invoice-details {
            margin-bottom: 20px;
        }
        .invoice-details-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .invoice-details-label {
            font-weight: bold;
            color: #6c757d;
        }
        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .invoice-table th, .invoice-table td {
            border: 1px solid #dee2e6;
            padding: 8px;
            text-align: right;
        }
        .invoice-table th {
            background-color: #f8f9fa;
            font-weight: bold;
        }
        .invoice-footer {
            border-top: 1px solid #f4f6f9;
            padding-top: 20px;
            margin-top: 20px;
            text-align: center;
        }
        .signature-area {
            display: flex;
            justify-content: space-between;
            margin-top: 50px;
        }
        .signature-box {
            border-top: 1px solid #dee2e6;
            width: 200px;
            padding-top: 10px;
            text-align: center;
        }
        .status-completed {
            color: #28a745;
            font-weight: bold;
        }
        .status-pending {
            color: #ffc107;
            font-weight: bold;
        }
        .status-cancelled {
            color: #dc3545;
            font-weight: bold;
        }
        .status-in-progress {
            color: #17a2b8;
            font-weight: bold;
        }
        .priority-high {
            color: #dc3545;
        }
        .priority-medium {
            color: #ffc107;
        }
        .priority-low {
            color: #28a745;
        }
        .priority-urgent {
            color: #dc3545;
            font-weight: bold;
        }
        @media print {
            body {
                background-color: #fff;
            }
            .invoice {
                border: none;
                padding: 0;
                max-width: 100%;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="invoice">
            <div class="invoice-header">
                <div class="row">
                    <div class="col-md-6">
                        <div class="invoice-title">تقرير صيانة مصعد</div>
                        <div>{{ $maintenance->company->name ?? 'شركة المصاعد' }}</div>
                        <div>{{ $maintenance->company->address ?? '' }}</div>
                        <div>{{ $maintenance->company->phone ?? '' }}</div>
                    </div>
                    <div class="col-md-6 text-left">
                        <h4>رقم التقرير: #{{ $maintenance->id }}</h4>
                        <div>تاريخ الصيانة: {{ $maintenance->maintenance_date->format('Y-m-d') }}</div>
                        @if($maintenance->status == 'completed')
                            <div>تاريخ الإكمال: {{ $maintenance->completion_date ? $maintenance->completion_date->format('Y-m-d') : $maintenance->updated_at->format('Y-m-d') }}</div>
                        @endif
                    </div>
                </div>
            </div>
            
            <div class="invoice-details">
                <div class="row">
                    <div class="col-md-6">
                        <h5>معلومات المصعد</h5>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">اسم المصعد:</span>
                            <span>{{ $maintenance->elevator->name ?? 'غير محدد' }}</span>
                        </div>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">المبنى:</span>
                            <span>{{ $maintenance->elevator->building_name ?? 'غير محدد' }}</span>
                        </div>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">العنوان:</span>
                            <span>{{ $maintenance->elevator->address ?? 'غير محدد' }}</span>
                        </div>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">الموديل:</span>
                            <span>{{ $maintenance->elevator->model->name ?? 'غير محدد' }}</span>
                        </div>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">الرقم التسلسلي:</span>
                            <span>{{ $maintenance->elevator->serial_number ?? 'غير محدد' }}</span>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <h5>معلومات الصيانة</h5>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">نوع الصيانة:</span>
                            <span class="
                                @if($maintenance->maintenance_type == 'corrective' || $maintenance->maintenance_type == 'emergency') text-danger font-weight-bold
                                @elseif($maintenance->maintenance_type == 'preventive') text-success font-weight-bold
                                @elseif($maintenance->maintenance_type == 'inspection') text-info font-weight-bold
                                @endif">
                                {{ $maintenance->getMaintenanceTypeName() }}
                            </span>
                        </div>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">الحالة:</span>
                            <span class="
                                @if($maintenance->status == 'completed') status-completed
                                @elseif($maintenance->status == 'pending') status-pending
                                @elseif($maintenance->status == 'in_progress') status-in-progress
                                @elseif($maintenance->status == 'cancelled') status-cancelled
                                @endif">
                                @if($maintenance->status == 'pending')
                                    قيد الانتظار
                                @elseif($maintenance->status == 'in_progress')
                                    قيد التنفيذ
                                @elseif($maintenance->status == 'completed')
                                    مكتملة
                                @elseif($maintenance->status == 'cancelled')
                                    ملغية
                                @else
                                    {{ $maintenance->status }}
                                @endif
                            </span>
                        </div>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">الأولوية:</span>
                            <span class="
                                @if($maintenance->priority == 'low') priority-low
                                @elseif($maintenance->priority == 'medium') priority-medium
                                @elseif($maintenance->priority == 'high') priority-high
                                @elseif($maintenance->priority == 'urgent') priority-urgent
                                @endif">
                                @if($maintenance->priority == 'low')
                                    منخفضة
                                @elseif($maintenance->priority == 'medium')
                                    متوسطة
                                @elseif($maintenance->priority == 'high')
                                    عالية
                                @elseif($maintenance->priority == 'urgent')
                                    عاجلة
                                @endif
                            </span>
                        </div>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">الفني المسؤول:</span>
                            <span>{{ $maintenance->technician->name ?? 'غير محدد' }}</span>
                        </div>
                        <div class="invoice-details-row">
                            <span class="invoice-details-label">رقم الهاتف:</span>
                            <span>{{ $maintenance->technician->phone ?? 'غير محدد' }}</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-12">
                    <h5>وصف المشكلة / الصيانة</h5>
                    <p>{{ $maintenance->description }}</p>
                </div>
            </div>
            
            @if($maintenance->tasks)
                <div class="row mt-3">
                    <div class="col-md-12">
                        <h5>المهام المطلوبة</h5>
                        <p>{{ $maintenance->tasks }}</p>
                    </div>
                </div>
            @endif
            
            @if($maintenance->parts->count() > 0)
                <div class="row mt-3">
                    <div class="col-md-12">
                        <h5>قطع الغيار المستخدمة</h5>
                        <table class="invoice-table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>اسم القطعة</th>
                                    <th>رقم القطعة</th>
                                    <th>الكمية</th>
                                    <th>السعر</th>
                                    <th>الإجمالي</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($maintenance->parts as $index => $part)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $part->name }}</td>
                                        <td>{{ $part->part_number ?? 'غير محدد' }}</td>
                                        <td>{{ $part->pivot->quantity ?? 1 }}</td>
                                        <td>{{ $part->selling_price ?? 0 }}</td>
                                        <td>{{ ($part->pivot->quantity ?? 1) * ($part->selling_price ?? 0) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="5" class="text-right">إجمالي تكلفة قطع الغيار:</th>
                                    <th>{{ $maintenance->parts_cost ?? 0 }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            @endif
            
            <div class="row mt-3">
                <div class="col-md-12">
                    <h5>ملخص التكاليف</h5>
                    <table class="invoice-table">
                        <tbody>
                            <tr>
                                <td>تكلفة العمالة</td>
                                <td>{{ $maintenance->actual_cost ? ($maintenance->actual_cost - ($maintenance->parts_cost ?? 0)) : ($maintenance->cost - ($maintenance->parts_cost ?? 0)) }}</td>
                            </tr>
                            <tr>
                                <td>تكلفة قطع الغيار</td>
                                <td>{{ $maintenance->parts_cost ?? 0 }}</td>
                            </tr>
                            <tr>
                                <td>إجمالي التكلفة</td>
                                <td><strong>{{ $maintenance->actual_cost ?? $maintenance->cost }}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            
            @if($maintenance->status == 'completed')
                <div class="row mt-3">
                    <div class="col-md-12">
                        <h5>ملاحظات الإكمال</h5>
                        <p>{{ $maintenance->completion_notes ?? 'لا توجد ملاحظات' }}</p>
                    </div>
                </div>
                
                @if($maintenance->recommendations)
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <h5>التوصيات والإجراءات المستقبلية</h5>
                            <p>{{ $maintenance->recommendations }}</p>
                        </div>
                    </div>
                @endif
            @endif
            
            <div class="signature-area">
                <div class="signature-box">
                    <p>توقيع الفني</p>
                    <p>{{ $maintenance->technician->name ?? 'غير محدد' }}</p>
                </div>
                
                <div class="signature-box">
                    <p>توقيع المشرف</p>
                    <p>_________________</p>
                </div>
                
                <div class="signature-box">
                    <p>توقيع العميل</p>
                    <p>_________________</p>
                </div>
            </div>
            
            <div class="invoice-footer">
                <p>تم إنشاء هذا التقرير بواسطة نظام إدارة المصاعد</p>
                <p>{{ date('Y-m-d H:i:s') }}</p>
            </div>
            
            <div class="no-print text-center mt-4">
                <button onclick="window.print();" class="btn btn-primary">
                    <i class="fas fa-print"></i> طباعة
                </button>
                <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-right"></i> العودة
                </a>
            </div>
        </div>
    </div>
</body>
</html>