@extends('layouts.app')

@section('title', 'جداول الصيانة الدورية')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة جداول الصيانة الدورية</h3>
                    <div class="card-tools">
                        <!-- تم إزالة زر إضافة جدول صيانة جديد -->
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    {{-- 
                    معلومات تشخيصية للمطور:
                    هذا القسم كان يعرض معلومات تشخيصية عن الاستعلام والفلاتر المطبقة.
                    تم إخفاؤه من المستخدم النهائي وتحويله إلى تعليق للمطورين فقط.
                    
                    المتغير $diagnosticMessage يحتوي على معلومات مثل:
                    - عدد جداول الصيانة
                    - الفلاتر المطبقة
                    - توزيع السجلات حسب الحالة
                    - توزيع سجلات الصيانة حسب النوع
                    - معلومات تشخيصية للمطورين (تظهر فقط للمشرفين)
                    --}}
                    
                    @if(count($maintenances) == 0)
                        <div class="alert alert-warning">
                            <h5><i class="icon fas fa-exclamation-triangle"></i> لم يتم العثور على جداول صيانة</h5>
                            <p>لم يتم العثور على جداول صيانة غير مكتملة في النظام. يمكنك تجربة ما يلي:</p>
                            <ul>
                                <li>توسيع نطاق البحث بتاريخ أوسع</li>
                                <li>ترك حقل البحث فارغًا للحصول على جميع النتائج</li>
                            </ul>
                            <p>
                                <a href="{{ route('maintenance-schedules.index') }}" class="btn btn-sm btn-info">
                                    <i class="fas fa-calendar-alt"></i> عرض جداول الصيانة في الصفحة الرئيسية
                                </a>
                                {{-- تم إزالة زر إضافة جدول صيانة جديد --}}
                            </p>
                        </div>
                    @endif
                    
                    <!-- Filter Form -->
                    <form method="GET" action="{{ route('elevator-maintenance.periodic') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="search">بحث (اسم العميل / رقم المصعد / السنة)</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="search" name="search" value="{{ request('search') }}" placeholder="ادخل اسم العميل أو رقم المصعد أو السنة">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-outline-secondary" onclick="document.getElementById('search').value = ''; this.form.submit();">
                                                <i class="fas fa-times"></i> الكل
                                            </button>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted">اترك الحقل فارغًا لعرض جميع العملاء</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد</label>
                                    <select name="elevator_id" id="elevator_id" class="form-control">
                                        <option value="">الكل</option>
                                        @php
                                            // جمع المصاعد الفريدة من نتائج الصيانة
                                            $elevators = \App\Models\Elevator::select('id', 'serial_number')
                                                ->whereHas('maintenances')
                                                ->orderBy('serial_number')
                                                ->get();
                                        @endphp
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ request('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->serial_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="start_date">من تاريخ</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ request('start_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="end_date">إلى تاريخ</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ request('end_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <div class="form-group mb-0 w-100">
                                    <button type="submit" class="btn btn-primary mr-2">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                    <a href="{{ route('elevator-maintenance.periodic') }}" class="btn btn-secondary">
                                        <i class="fas fa-redo"></i> إعادة تعيين
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <!-- خيارات إضافية للبحث -->
                        <div class="row mt-2">
                            <div class="col-md-6">
                                {{-- تم إلغاء خيار عرض الصيانات المكتملة والملغاة --}}
                                <div class="form-check" style="display: none;">
                                    <input class="form-check-input" type="checkbox" id="show_completed" name="show_completed" value="0" disabled>
                                    <label class="form-check-label" for="show_completed">
                                        <!-- تم إلغاء هذا الخيار وإخفاؤه من المستخدم -->
                                    </label>
                                </div>
                            </div>
                            <!-- تم إزالة فلتر أنواع الصيانة -->
                        </div>
                    </form>
                    
                    <div class="table-responsive">
                        <table class="table table-hover text-nowrap">
                            <thead>
                                <tr>
                                    <th>رقم المصعد</th>
                                    <th>اسم العميل</th>
                                    <th>الموقع (GPS)</th>
                                    <th>تاريخ الصيانة المجدولة</th>
                                    <th>متبقي</th>
                                    <th>الحالة</th>
                                    <th>المستخدم المسؤول</th>
                                    <th>التحكم</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($maintenances as $maintenance)
                                    <tr>
                                        <td>
                                            <a href="{{ route('elevators.show', $maintenance->elevator_id) }}">
                                                {{ $maintenance->elevator->serial_number ?? 'غير محدد' }}
                                            </a>
                                        </td>
                                        <td>{{ $maintenance->elevator->customer->name ?? 'غير محدد' }}</td>
                                        <td>
                                            @if($maintenance->elevator->location && ($maintenance->elevator->location->latitude || $maintenance->elevator->location->longitude))
                                                <a href="https://www.google.com/maps?q={{ $maintenance->elevator->location->latitude }},{{ $maintenance->elevator->location->longitude }}" target="_blank">
                                                    <i class="fas fa-map-marker-alt"></i> عرض الموقع
                                                </a>
                                            @elseif($maintenance->elevator->location)
                                                {{ $maintenance->elevator->location->name ?? 'غير محدد' }}
                                            @else
                                                غير محدد
                                            @endif
                                        </td>
                                        <td>{{ $maintenance->scheduled_date->format('Y-m-d') }}</td>
                                        <td>
                                            @php
                                                $daysLeft = now()->diffInDays($maintenance->scheduled_date, false);
                                            @endphp
                                            
                                            @if($daysLeft < 0)
                                                <span class="badge badge-danger">متأخر {{ abs($daysLeft) }} يوم</span>
                                            @elseif($daysLeft == 0)
                                                <span class="badge badge-warning">اليوم</span>
                                            @else
                                                <span class="badge badge-info">{{ $daysLeft }} يوم</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($maintenance->status == 'scheduled')
                                                <span class="badge badge-warning">مجدولة</span>
                                            @elseif($maintenance->status == 'completed')
                                                <span class="badge badge-success">مكتملة</span>
                                            @elseif($maintenance->status == 'missed')
                                                <span class="badge badge-danger">فائتة</span>
                                            @elseif($maintenance->status == 'cancelled')
                                                <span class="badge badge-secondary">ملغاة</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $maintenance->status }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $maintenance->user->name ?? 'غير محدد' }}</td>
                                        <td>
                                            <a href="{{ route('maintenance-schedules.show', $maintenance->id) }}" class="btn btn-sm btn-info" title="عرض جدول الصيانة">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('maintenance-schedules.edit', $maintenance->id) }}" class="btn btn-sm btn-warning" title="تعديل الحالة">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="{{ route('elevator-maintenance.create', ['type' => 'preventive', 'schedule_id' => $maintenance->id]) }}" class="btn btn-sm btn-success" title="إنشاء صيانة من هذا الجدول">
                                                <i class="fas fa-plus"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد جداول صيانة مستحقة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $maintenances->appends(request()->query())->links() }}
                </div>
                
                {{-- 
                معلومات تشخيصية إضافية (تم إخفاؤها من المستخدم وتحويلها إلى تعليق):
                - معايير البحث الحالية: البحث، من تاريخ، إلى تاريخ، عرض الصيانات المكتملة
                - أسباب عدم ظهور نتائج:
                  * لا توجد صيانات دورية مجدولة في الفترة المحددة
                  * جميع الصيانات الدورية في هذه الفترة مكتملة أو ملغاة
                  * معايير البحث محددة بشكل ضيق جدًا
                  * لم يتم إنشاء جداول صيانة دورية بعد
                
                نصائح للبحث:
                - للبحث عن صيانات في سنة معينة، أدخل السنة في حقل البحث (مثل: 2025)
                - للبحث عن صيانات في شهر معين، أدخل رقم الشهر في حقل البحث (مثل: 9 للبحث في سبتمبر)
                - إذا كنت تبحث عن صيانات مكتملة، فعّل خيار "عرض الصيانات المكتملة"
                - للبحث عن جميع أنواع الصيانة (وليس فقط الدورية)، فعّل خيار "عرض جميع أنواع الصيانة"
                --}}
                    
                    {{-- تم إزالة أزرار التحقق من جداول الصيانة الدورية وإدارة جداول الصيانة الدورية --}}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(function() {
        // Add any JavaScript functionality here if needed
    });
</script>
@endpush