@extends('layouts.app')

@section('title', 'إدارة صيانة المصاعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- بطاقة التبويبات للتمييز بين أنواع الصيانة -->
            <div class="card card-primary card-outline card-outline-tabs">
                <div class="card-header p-0 border-bottom-0">
                    <ul class="nav nav-tabs" id="maintenance-tabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="all-tab" data-toggle="pill" href="#all" role="tab" aria-controls="all" aria-selected="true">
                                <i class="fas fa-tools"></i> جميع عمليات الصيانة
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="breakdown-tab" data-toggle="pill" href="#breakdown" role="tab" aria-controls="breakdown" aria-selected="false">
                                <i class="fas fa-exclamation-triangle"></i> صيانة الأعطال
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="periodic-tab" data-toggle="pill" href="#periodic" role="tab" aria-controls="periodic" aria-selected="false">
                                <i class="fas fa-calendar-check"></i> الصيانة الدورية
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة عمليات صيانة المصاعد</h3>
                    <div class="card-tools">
                        <div class="btn-group">
                            <a href="{{ route('elevator-maintenance.create') }}" class="btn btn-sm btn-primary">
                                <i class="fas fa-plus"></i> إضافة صيانة جديدة
                            </a>
                            <button type="button" class="btn btn-sm btn-primary dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-expanded="false">
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu dropdown-menu-right">
                                <a class="dropdown-item" href="{{ route('elevator-maintenance.create') }}?type=corrective">
                                    <i class="fas fa-wrench text-danger"></i> إضافة صيانة أعطال
                                </a>
                                <a class="dropdown-item" href="{{ route('elevator-maintenance.create') }}?type=preventive">
                                    <i class="fas fa-calendar-check text-success"></i> إضافة صيانة دورية
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible m-3">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <div class="tab-content" id="maintenance-tabsContent">
                        <!-- جميع عمليات الصيانة -->
                        <div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all-tab">
                            <table class="table table-hover text-nowrap">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>المصعد</th>
                                        <th>نوع الصيانة</th>
                                        <th>تاريخ الصيانة</th>
                                        <th>الفني المسؤول</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($maintenances as $index => $maintenance)
                                        <tr class="{{ $maintenance->isBreakdownMaintenance() ? 'table-danger' : ($maintenance->isPeriodicMaintenance() ? 'table-success' : '') }}">
                                            <td>{{ $index + 1 }}</td>
                                            <td>
                                                <a href="{{ route('elevators.show', $maintenance->elevator_id) }}">
                                                    {{ $maintenance->elevator->serial_number ?? 'غير محدد' }}
                                                </a>
                                            </td>
                                            <td>
                                                @if($maintenance->maintenance_type == 'corrective')
                                                    <span class="badge badge-danger"><i class="fas fa-wrench"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                @elseif($maintenance->maintenance_type == 'emergency')
                                                    <span class="badge badge-danger"><i class="fas fa-exclamation-triangle"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                @elseif($maintenance->maintenance_type == 'preventive')
                                                    <span class="badge badge-success"><i class="fas fa-calendar-check"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                @elseif($maintenance->maintenance_type == 'inspection')
                                                    <span class="badge badge-info"><i class="fas fa-clipboard-check"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                @else
                                                    <span class="badge badge-secondary"><i class="fas fa-cog"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                @endif
                                            </td>
                                            <td>{{ $maintenance->scheduled_date->format('Y-m-d') }}</td>
                                            <td>{{ $maintenance->technician->name ?? 'غير محدد' }}</td>
                                            <td>
                                                @if($maintenance->status == 'pending')
                                                    <span class="badge badge-warning">قيد الانتظار</span>
                                                @elseif($maintenance->status == 'in_progress')
                                                    <span class="badge badge-info">قيد التنفيذ</span>
                                                @elseif($maintenance->status == 'completed')
                                                    <span class="badge badge-success">مكتملة</span>
                                                @elseif($maintenance->status == 'cancelled')
                                                    <span class="badge badge-danger">ملغية</span>
                                                @else
                                                    <span class="badge badge-secondary">{{ $maintenance->status }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('elevator-maintenance.edit', $maintenance->id) }}" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('elevator-maintenance.destroy', $maintenance->id) }}" method="POST" style="display: inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه العملية؟')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center">لا توجد عمليات صيانة مسجلة</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- صيانة الأعطال فقط -->
                        <div class="tab-pane fade" id="breakdown" role="tabpanel" aria-labelledby="breakdown-tab">
                            <div class="alert alert-danger">
                                <h5><i class="icon fas fa-exclamation-triangle"></i> صيانة الأعطال</h5>
                                تعرض هذه القائمة عمليات صيانة الأعطال والصيانة الطارئة فقط
                            </div>
                            <table class="table table-hover text-nowrap">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>المصعد</th>
                                        <th>نوع الصيانة</th>
                                        <th>تاريخ الصيانة</th>
                                        <th>الفني المسؤول</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $breakdownCount = 0; @endphp
                                    @foreach($maintenances as $index => $maintenance)
                                        @if($maintenance->isBreakdownMaintenance())
                                            @php $breakdownCount++; @endphp
                                            <tr class="table-danger">
                                                <td>{{ $breakdownCount }}</td>
                                                <td>
                                                    <a href="{{ route('elevators.show', $maintenance->elevator_id) }}">
                                                        {{ $maintenance->elevator->name ?? 'غير محدد' }}
                                                    </a>
                                                </td>
                                                <td>
                                                    @if($maintenance->maintenance_type == 'corrective')
                                                        <span class="badge badge-danger"><i class="fas fa-wrench"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                    @elseif($maintenance->maintenance_type == 'emergency')
                                                        <span class="badge badge-danger"><i class="fas fa-exclamation-triangle"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                    @endif
                                                </td>
                                                <td>{{ $maintenance->scheduled_date->format('Y-m-d') }}</td>
                                                <td>{{ $maintenance->technician->name ?? 'غير محدد' }}</td>
                                                <td>
                                                    @if($maintenance->status == 'pending')
                                                        <span class="badge badge-warning">قيد الانتظار</span>
                                                    @elseif($maintenance->status == 'in_progress')
                                                        <span class="badge badge-info">قيد التنفيذ</span>
                                                    @elseif($maintenance->status == 'completed')
                                                        <span class="badge badge-success">مكتملة</span>
                                                    @elseif($maintenance->status == 'cancelled')
                                                        <span class="badge badge-danger">ملغية</span>
                                                    @else
                                                        <span class="badge badge-secondary">{{ $maintenance->status }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('elevator-maintenance.edit', $maintenance->id) }}" class="btn btn-sm btn-warning">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('elevator-maintenance.destroy', $maintenance->id) }}" method="POST" style="display: inline-block;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه العملية؟')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                    
                                    @if($breakdownCount == 0)
                                        <tr>
                                            <td colspan="7" class="text-center">لا توجد عمليات صيانة أعطال مسجلة</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- الصيانة الدورية فقط -->
                        <div class="tab-pane fade" id="periodic" role="tabpanel" aria-labelledby="periodic-tab">
                            <div class="alert alert-success">
                                <h5><i class="icon fas fa-calendar-check"></i> الصيانة الدورية</h5>
                                تعرض هذه القائمة عمليات الصيانة الدورية والفحص الدوري فقط
                            </div>
                            <table class="table table-hover text-nowrap">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>المصعد</th>
                                        <th>نوع الصيانة</th>
                                        <th>تاريخ الصيانة</th>
                                        <th>الفني المسؤول</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $periodicCount = 0; @endphp
                                    @foreach($maintenances as $index => $maintenance)
                                        @if($maintenance->isPeriodicMaintenance())
                                            @php $periodicCount++; @endphp
                                            <tr class="table-success">
                                                <td>{{ $periodicCount }}</td>
                                                <td>
                                                    <a href="{{ route('elevators.show', $maintenance->elevator_id) }}">
                                                        {{ $maintenance->elevator->name ?? 'غير محدد' }}
                                                    </a>
                                                </td>
                                                <td>
                                                    @if($maintenance->maintenance_type == 'preventive')
                                                        <span class="badge badge-success"><i class="fas fa-calendar-check"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                    @elseif($maintenance->maintenance_type == 'inspection')
                                                        <span class="badge badge-info"><i class="fas fa-clipboard-check"></i> {{ $maintenance->getMaintenanceTypeName() }}</span>
                                                    @endif
                                                </td>
                                                <td>{{ $maintenance->scheduled_date->format('Y-m-d') }}</td>
                                                <td>{{ $maintenance->technician->name ?? 'غير محدد' }}</td>
                                                <td>
                                                    @if($maintenance->status == 'pending')
                                                        <span class="badge badge-warning">قيد الانتظار</span>
                                                    @elseif($maintenance->status == 'in_progress')
                                                        <span class="badge badge-info">قيد التنفيذ</span>
                                                    @elseif($maintenance->status == 'completed')
                                                        <span class="badge badge-success">مكتملة</span>
                                                    @elseif($maintenance->status == 'cancelled')
                                                        <span class="badge badge-danger">ملغية</span>
                                                    @else
                                                        <span class="badge badge-secondary">{{ $maintenance->status }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('elevator-maintenance.edit', $maintenance->id) }}" class="btn btn-sm btn-warning">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('elevator-maintenance.destroy', $maintenance->id) }}" method="POST" style="display: inline-block;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه العملية؟')">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                    
                                    @if($periodicCount == 0)
                                        <tr>
                                            <td colspan="7" class="text-center">لا توجد عمليات صيانة دورية مسجلة</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $maintenances->links() }}
                </div>
            </div>
            <!-- /.card -->
            
            <!-- بطاقة الإحصائيات -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{{ $stats['total'] ?? 0 }}</h3>
                            <p>إجمالي عمليات الصيانة</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-tools"></i>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>{{ $stats['completed'] ?? 0 }}</h3>
                            <p>عمليات مكتملة</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3>{{ $stats['pending'] ?? 0 }}</h3>
                            <p>عمليات قيد الانتظار</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-clock"></i>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3>{{ $stats['urgent'] ?? 0 }}</h3>
                            <p>صيانة عاجلة</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection