@extends('layouts.app')

@section('title', 'تعديل عملية صيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-warning">
                <div class="card-header">
                    <h3 class="card-title">تعديل عملية صيانة #{{ $maintenance->id }}</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="POST" action="{{ route('elevator-maintenance.update', $maintenance->id) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد</label>
                                    <input type="hidden" name="elevator_id" value="{{ $maintenance->elevator_id }}">
                                    <input type="text" class="form-control" value="{{ $maintenance->elevator->serial_number }} - {{ $maintenance->elevator->location->name ?? 'غير محدد' }}" readonly>
                                    @error('elevator_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maintenance_type_display">نوع الصيانة</label>
                                    <input type="hidden" name="maintenance_type" value="corrective">
                                    <input type="text" class="form-control" value="صيانة تصحيحية" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="scheduled_date">تاريخ الصيانة <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('scheduled_date') is-invalid @enderror" id="scheduled_date" name="scheduled_date" value="{{ old('scheduled_date', $maintenance->scheduled_date->format('Y-m-d')) }}" required>
                                    @error('scheduled_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="technician_id">الفني المسؤول <span class="text-danger">*</span></label>
                                    <select class="form-control select2 @error('technician_id') is-invalid @enderror" id="technician_id" name="technician_id" required>
                                        <option value="">اختر الفني</option>
                                        @foreach($technicians as $technician)
                                            <option value="{{ $technician->id }}" {{ old('technician_id', $maintenance->technician_id) == $technician->id ? 'selected' : '' }}>
                                                {{ $technician->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('technician_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة <span class="text-danger">*</span></label>
                                    <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                        <option value="pending" {{ old('status', $maintenance->status) == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                        <option value="in_progress" {{ old('status', $maintenance->status) == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                        <option value="completed" {{ old('status', $maintenance->status) == 'completed' ? 'selected' : '' }}>مكتملة</option>
                                        <option value="cancelled" {{ old('status', $maintenance->status) == 'cancelled' ? 'selected' : '' }}>ملغية</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="priority">الأولوية <span class="text-danger">*</span></label>
                                    <select class="form-control @error('priority') is-invalid @enderror" id="priority" name="priority" required>
                                        <option value="low" {{ old('priority', $maintenance->priority) == 'low' ? 'selected' : '' }}>منخفضة</option>
                                        <option value="medium" {{ old('priority', $maintenance->priority) == 'medium' ? 'selected' : '' }}>متوسطة</option>
                                        <option value="high" {{ old('priority', $maintenance->priority) == 'high' ? 'selected' : '' }}>عالية</option>
                                        <option value="urgent" {{ old('priority', $maintenance->priority) == 'urgent' ? 'selected' : '' }}>عاجلة</option>
                                    </select>
                                    @error('priority')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="estimated_duration">المدة المقدرة (بالساعات)</label>
                                    <input type="number" class="form-control @error('estimated_duration') is-invalid @enderror" id="estimated_duration" name="estimated_duration" value="{{ old('estimated_duration', $maintenance->estimated_duration) }}" min="1">
                                    @error('estimated_duration')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="estimated_hours">الوقت المقدر (بالساعات)</label>
                                    <input type="number" step="0.5" min="0.5" class="form-control @error('estimated_hours') is-invalid @enderror" id="estimated_hours" name="estimated_hours" value="{{ old('estimated_hours', $maintenance->estimated_hours) }}" placeholder="أدخل الوقت المقدر للصيانة">
                                    @error('estimated_hours')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="actual_hours">الوقت الفعلي (بالساعات)</label>
                                    <input type="number" step="0.5" min="0" class="form-control @error('actual_hours') is-invalid @enderror" id="actual_hours" name="actual_hours" value="{{ old('actual_hours', $maintenance->actual_hours) }}" placeholder="أدخل الوقت الفعلي للصيانة">
                                    @error('actual_hours')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="cost">التكلفة المقدرة</label>
                                    <input type="number" step="0.01" min="0" class="form-control @error('cost') is-invalid @enderror" id="cost" name="cost" value="{{ old('cost', $maintenance->cost) }}" placeholder="أدخل التكلفة المقدرة للصيانة">
                                    @error('cost')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="actual_cost">التكلفة الفعلية</label>
                                    <input type="number" step="0.01" min="0" class="form-control @error('actual_cost') is-invalid @enderror" id="actual_cost" name="actual_cost" value="{{ old('actual_cost', $maintenance->actual_cost) }}" placeholder="أدخل التكلفة الفعلية للصيانة">
                                    @error('actual_cost')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">وصف المشكلة / الصيانة <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3" required placeholder="أدخل وصف المشكلة أو الصيانة المطلوبة">{{ old('description', $maintenance->description) }}</textarea>
                            @error('description')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="tasks">المهام المطلوبة</label>
                            <textarea class="form-control @error('tasks') is-invalid @enderror" id="tasks" name="tasks" rows="3" placeholder="أدخل المهام المطلوبة للصيانة">{{ old('tasks', $maintenance->tasks) }}</textarea>
                            @error('tasks')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="notes">ملاحظات الصيانة</label>
                            <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3" placeholder="أدخل ملاحظات الصيانة">{{ old('notes', $maintenance->notes) }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="parts_used">قطع الغيار المستخدمة</label>
                            <select class="form-control select2 @error('parts_used') is-invalid @enderror" id="parts_used" name="parts_used[]" multiple>
                                @foreach($parts as $part)
                                    <option value="{{ $part->id }}" {{ (old('parts_used') && in_array($part->id, old('parts_used'))) || (is_null(old('parts_used')) && $maintenance->parts->contains($part->id)) ? 'selected' : '' }}>
                                        {{ $part->name }} ({{ $part->part_number ?? 'بدون رقم' }})
                                    </option>
                                @endforeach
                            </select>
                            @error('parts_used')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="attachments">إضافة مرفقات جديدة</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('attachments') is-invalid @enderror" id="attachments" name="attachments[]" multiple>
                                    <label class="custom-file-label" for="attachments">اختر الملفات</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">يمكنك تحميل صور أو مستندات متعلقة بالصيانة (الحد الأقصى: 5 ملفات، 2MB لكل ملف)</small>
                            @error('attachments')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        @if($maintenance->attachments->count() > 0)
                            <div class="form-group">
                                <label>المرفقات الحالية:</label>
                                <div class="row">
                                    @foreach($maintenance->attachments as $attachment)
                                        <div class="col-md-3">
                                            <div class="attachment-block clearfix">
                                                <a href="{{ asset('storage/' . $attachment->path) }}" target="_blank">
                                                    @if(in_array(pathinfo($attachment->path, PATHINFO_EXTENSION), ['jpg', 'jpeg', 'png', 'gif']))
                                                        <img class="attachment-img" src="{{ asset('storage/' . $attachment->path) }}" alt="مرفق">
                                                    @else
                                                        <div class="attachment-icon"><i class="fas fa-file"></i></div>
                                                    @endif
                                                    <div class="attachment-pushed">
                                                        <h4 class="attachment-heading">{{ $attachment->name }}</h4>
                                                        <div class="attachment-text">{{ $attachment->created_at->format('Y-m-d') }}</div>
                                                    </div>
                                                </a>
                                                <div class="form-check mt-2">
                                                    <input class="form-check-input" type="checkbox" name="delete_attachments[]" value="{{ $attachment->id }}" id="attachment{{ $attachment->id }}">
                                                    <label class="form-check-label" for="attachment{{ $attachment->id }}">
                                                        حذف هذا المرفق
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        
                        @if($maintenance->status == 'completed')
                            <div class="form-group">
                                <label for="completion_date">تاريخ إكمال الصيانة</label>
                                <input type="date" class="form-control @error('completion_date') is-invalid @enderror" id="completion_date" name="completion_date" value="{{ old('completion_date', $maintenance->completion_date ? $maintenance->completion_date->format('Y-m-d') : date('Y-m-d')) }}">
                                @error('completion_date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group">
                                <label for="completion_notes">ملاحظات الإكمال</label>
                                <textarea class="form-control @error('completion_notes') is-invalid @enderror" id="completion_notes" name="completion_notes" rows="3" placeholder="أدخل ملاحظات إكمال الصيانة">{{ old('completion_notes', $maintenance->completion_notes) }}</textarea>
                                @error('completion_notes')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        @endif
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="notify_customer" name="notify_customer" value="1" {{ old('notify_customer', $maintenance->notify_customer) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="notify_customer">إشعار العميل بالصيانة</label>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-warning">تحديث</button>
                        <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        //Initialize Select2 Elements
        $('.select2').select2();
        
        // Custom file input
        bsCustomFileInput.init();
    });
</script>
@endsection