@extends('layouts.app')

@section('title', 'إضافة بلاغ عطل جديد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-danger">
                <div class="card-header">
                    <h3 class="card-title">
                        <span id="maintenance-title">إضافة بلاغ عطل جديد</span>
                        <span id="maintenance-type-badge" class="badge badge-danger ml-2"></span>
                    </h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="POST" action="{{ route('elevator-maintenance.store') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد <span class="text-danger">*</span></label>
                                    <select class="form-control select2 @error('elevator_id') is-invalid @enderror" id="elevator_id" name="elevator_id" required>
                                        <option value="">اختر المصعد</option>
                                        @forelse($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" 
                                                data-serial="{{ $elevator->serial_number }}"
                                                data-model="{{ $elevator->model }}"
                                                data-manufacturer="{{ $elevator->manufacturer }}"
                                                data-location="{{ $elevator->location->name ?? 'غير محدد' }}"
                                                data-status="{{ $elevator->status }}"
                                                {{ old('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->serial_number }} - {{ $elevator->manufacturer }} {{ $elevator->model }} - {{ $elevator->location->name ?? 'غير محدد' }}
                                            </option>
                                        @empty
                                            <option value="" disabled>لا توجد مصاعد متاحة</option>
                                        @endforelse
                                    </select>
                                    @if($elevators->isEmpty())
                                        <small class="text-danger">لم يتم العثور على أي مصاعد. يرجى إضافة مصاعد أولاً.</small>
                                    @endif
                                    @error('elevator_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                
                                <!-- معلومات المصعد المحدد -->
                                <div id="elevator-info" class="mt-2 p-2 border rounded d-none">
                                    <h6 class="font-weight-bold">معلومات المصعد:</h6>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>الرقم التسلسلي:</strong> <span id="elevator-serial"></span></p>
                                            <p><strong>الموديل:</strong> <span id="elevator-model"></span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>الشركة المصنعة:</strong> <span id="elevator-manufacturer"></span></p>
                                            <p><strong>الموقع:</strong> <span id="elevator-location"></span></p>
                                        </div>
                                    </div>
                                    <p><strong>الحالة:</strong> <span id="elevator-status" class="badge badge-info"></span></p>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maintenance_type">نوع العطل <span class="text-danger">*</span></label>
                                    <select class="form-control @error('maintenance_type') is-invalid @enderror" id="maintenance_type" name="maintenance_type" required>
                                        <option value="">اختر نوع العطل</option>
                                        <option value="corrective" data-category="breakdown" {{ old('maintenance_type') == 'corrective' || $maintenanceType == 'corrective' ? 'selected' : 'selected' }}>عطل عادي</option>
                                        <option value="emergency" data-category="breakdown" {{ old('maintenance_type') == 'emergency' || $maintenanceType == 'emergency' ? 'selected' : '' }}>عطل طارئ</option>
                                    </select>
                                    <input type="hidden" name="maintenance_type_category" value="breakdown">
                                    @error('maintenance_type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="report_date">تاريخ البلاغ <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('scheduled_date') is-invalid @enderror" id="report_date" name="scheduled_date" value="{{ old('scheduled_date', date('Y-m-d')) }}" required readonly>
                                    <small class="text-muted">تاريخ اليوم (تلقائي)</small>
                                    @error('scheduled_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="priority">الأولوية <span class="text-danger">*</span></label>
                                    <select class="form-control @error('priority') is-invalid @enderror" id="priority" name="priority" required>
                                        <option value="medium" {{ old('priority') == 'medium' ? 'selected' : '' }}>متوسطة</option>
                                        <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>عالية</option>
                                        <option value="urgent" {{ old('priority') == 'urgent' ? 'selected' : '' }}>عاجلة</option>
                                    </select>
                                    @error('priority')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <!-- حقول مخفية للمتطلبات -->
                        <input type="hidden" name="status" value="scheduled">
                        <input type="hidden" name="technician_id" value="{{ $technicians->first()->id ?? '' }}">
                        <input type="hidden" name="estimated_duration" value="1">
                        
                        <div class="form-group">
                            <label for="description">وصف العطل <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="4" required placeholder="أدخل وصف تفصيلي للعطل">{{ old('description') }}</textarea>
                            @error('description')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="reporter_name">اسم المبلغ <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('reporter_name') is-invalid @enderror" id="reporter_name" name="reporter_name" value="{{ old('reporter_name') }}" required placeholder="أدخل اسم الشخص المبلغ عن العطل">
                            @error('reporter_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="reporter_phone">رقم هاتف المبلغ <span class="text-danger">*</span></label>
                            <input type="text" class="form-control @error('reporter_phone') is-invalid @enderror" id="reporter_phone" name="reporter_phone" value="{{ old('reporter_phone') }}" required placeholder="أدخل رقم هاتف المبلغ عن العطل">
                            @error('reporter_phone')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="attachments">صور العطل</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('attachments') is-invalid @enderror" id="attachments" name="attachments[]" multiple accept="image/*">
                                    <label class="custom-file-label" for="attachments">اختر الصور</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">يمكنك تحميل صور للعطل (الحد الأقصى: 5 صور، 2MB لكل صورة)</small>
                            @error('attachments')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="is_urgent" name="is_urgent" value="1" {{ old('is_urgent') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_urgent">هذا العطل يتطلب تدخل فوري (حالة طارئة)</label>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-danger">تسجيل البلاغ</button>
                        <a href="{{ route('elevator-maintenance.index') }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        //Initialize Select2 Elements with search and placeholder
        $('.select2').select2({
            placeholder: "اختر المصعد",
            allowClear: true,
            width: '100%',
            language: {
                noResults: function() {
                    return "لا توجد نتائج";
                },
                searching: function() {
                    return "جاري البحث...";
                }
            }
        });
        
        // Custom file input
        bsCustomFileInput.init();
        
        // تحديث عنوان الصفحة بناءً على نوع العطل
        function updateMaintenanceTitle() {
            var selectedOption = $('#maintenance_type option:selected');
            var maintenanceType = selectedOption.val();
            var typeBadge = $('#maintenance-type-badge');
            
            // إعادة تعيين العنوان الافتراضي
            if (!maintenanceType) {
                typeBadge.text('').removeClass('badge-danger').addClass('badge-light');
                return;
            }
            
            // تحديث الشارة بناءً على نوع العطل
            if (maintenanceType === 'emergency') {
                typeBadge.text('عطل طارئ').removeClass('badge-light').addClass('badge-danger');
                // تحديد الأولوية كعاجلة تلقائيًا
                $('#priority').val('urgent');
                // تفعيل خيار الحالة الطارئة
                $('#is_urgent').prop('checked', true);
            } else {
                typeBadge.text('عطل عادي').removeClass('badge-light').addClass('badge-danger');
            }
        }
        
        // تنفيذ الدالة عند تحميل الصفحة
        updateMaintenanceTitle();
        
        // تنفيذ الدالة عند تغيير نوع العطل
        $('#maintenance_type').on('change', updateMaintenanceTitle);
        
        // تحديث حالة الطوارئ عند تغيير الأولوية
        $('#priority').on('change', function() {
            if ($(this).val() === 'urgent') {
                $('#is_urgent').prop('checked', true);
                $('#maintenance_type').val('emergency').trigger('change');
            }
        });
        
        // تحديث الأولوية عند تغيير حالة الطوارئ
        $('#is_urgent').on('change', function() {
            if ($(this).is(':checked')) {
                $('#priority').val('urgent');
                $('#maintenance_type').val('emergency').trigger('change');
            }
        });
        
        // تعيين تاريخ اليوم تلقائيًا
        var today = new Date();
        var dd = String(today.getDate()).padStart(2, '0');
        var mm = String(today.getMonth() + 1).padStart(2, '0');
        var yyyy = today.getFullYear();
        today = yyyy + '-' + mm + '-' + dd;
        $('#report_date').val(today);
        
        // عرض معلومات المصعد عند اختياره
        $('#elevator_id').on('change', function() {
            var selectedOption = $(this).find('option:selected');
            var elevatorId = $(this).val();
            
            if (elevatorId) {
                // استخراج البيانات من الخيار المحدد
                var serial = selectedOption.data('serial');
                var model = selectedOption.data('model');
                var manufacturer = selectedOption.data('manufacturer');
                var location = selectedOption.data('location');
                var status = selectedOption.data('status');
                
                // عرض البيانات في قسم معلومات المصعد
                $('#elevator-serial').text(serial);
                $('#elevator-model').text(model);
                $('#elevator-manufacturer').text(manufacturer);
                $('#elevator-location').text(location);
                
                // تحديد لون حالة المصعد
                var statusBadge = $('#elevator-status');
                statusBadge.text(getStatusText(status));
                statusBadge.removeClass('badge-info badge-success badge-warning badge-danger');
                
                switch(status) {
                    case 'operational':
                        statusBadge.addClass('badge-success');
                        break;
                    case 'under_maintenance':
                        statusBadge.addClass('badge-warning');
                        break;
                    case 'out_of_service':
                        statusBadge.addClass('badge-danger');
                        break;
                    case 'installation':
                        statusBadge.addClass('badge-info');
                        break;
                    default:
                        statusBadge.addClass('badge-info');
                }
                
                // إظهار قسم معلومات المصعد
                $('#elevator-info').removeClass('d-none');
            } else {
                // إخفاء قسم معلومات المصعد إذا لم يتم اختيار مصعد
                $('#elevator-info').addClass('d-none');
            }
        });
        
        // دالة لتحويل حالة المصعد إلى نص عربي
        function getStatusText(status) {
            switch(status) {
                case 'operational':
                    return 'يعمل';
                case 'under_maintenance':
                    return 'تحت الصيانة';
                case 'out_of_service':
                    return 'خارج الخدمة';
                case 'installation':
                    return 'قيد التركيب';
                default:
                    return status;
            }
        }
        
        // تنفيذ التغيير الأولي إذا كان هناك مصعد محدد مسبقًا
        if ($('#elevator_id').val()) {
            $('#elevator_id').trigger('change');
        }
    });
</script>
@endsection