@extends('layouts.app')

@section('title', 'عمليات صيانة المصاعد المكتملة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قائمة عمليات صيانة المصاعد المكتملة</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-maintenance.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة عملية صيانة جديدة
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body table-responsive p-0">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible m-3">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <table class="table table-hover text-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>المصعد</th>
                                <th>نوع الصيانة</th>
                                <th>تاريخ الصيانة</th>
                                <th>تاريخ الإكمال</th>
                                <th>الفني المسؤول</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($maintenances as $index => $maintenance)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <a href="{{ route('elevators.show', $maintenance->elevator_id) }}">
                                            {{ $maintenance->elevator->name ?? 'غير محدد' }}
                                        </a>
                                    </td>
                                    <td>
                                        @if($maintenance->maintenance_type == 'corrective')
                                            <span class="badge badge-danger">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'emergency')
                                            <span class="badge badge-danger">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'preventive')
                                            <span class="badge badge-success">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @elseif($maintenance->maintenance_type == 'inspection')
                                            <span class="badge badge-info">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @else
                                            <span class="badge badge-secondary">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $maintenance->scheduled_date->format('Y-m-d') }}</td>
                                    <td>{{ $maintenance->completion_date ? $maintenance->completion_date->format('Y-m-d') : 'غير محدد' }}</td>
                                    <td>{{ $maintenance->technician->name ?? 'غير محدد' }}</td>
                                    <td>
                                        <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('elevator-maintenance.edit', $maintenance->id) }}" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد عمليات صيانة مكتملة</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!-- /.card-body -->
                <div class="card-footer clearfix">
                    {{ $maintenances->links() }}
                </div>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection