@extends('layouts.app')

@section('title', 'إكمال عملية صيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-success">
                <div class="card-header">
                    <h3 class="card-title">إكمال عملية صيانة #{{ $maintenance->id }}</h3>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="POST" action="{{ route('elevator-maintenance.complete-store', $maintenance->id) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-info"><i class="fas fa-elevator"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">المصعد</span>
                                        <span class="info-box-number">{{ $maintenance->elevator->name ?? 'غير محدد' }}</span>
                                        <span class="info-box-text text-muted">{{ $maintenance->elevator->building_name ?? '' }}</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="info-box">
                                    @if($maintenance->maintenance_type == 'corrective' || $maintenance->maintenance_type == 'emergency')
                                        <span class="info-box-icon bg-danger"><i class="fas fa-tools"></i></span>
                                    @elseif($maintenance->maintenance_type == 'preventive' || $maintenance->maintenance_type == 'inspection')
                                        <span class="info-box-icon bg-success"><i class="fas fa-tools"></i></span>
                                    @else
                                        <span class="info-box-icon bg-warning"><i class="fas fa-tools"></i></span>
                                    @endif
                                    <div class="info-box-content">
                                        <span class="info-box-text">نوع الصيانة</span>
                                        <span class="info-box-number">
                                            @if($maintenance->maintenance_type == 'corrective')
                                                <span class="badge badge-danger">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                            @elseif($maintenance->maintenance_type == 'emergency')
                                                <span class="badge badge-danger">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                            @elseif($maintenance->maintenance_type == 'preventive')
                                                <span class="badge badge-success">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                            @elseif($maintenance->maintenance_type == 'inspection')
                                                <span class="badge badge-info">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $maintenance->getMaintenanceTypeName() }}</span>
                                            @endif
                                        </span>
                                        <span class="info-box-text text-muted">{{ $maintenance->maintenance_date->format('Y-m-d') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="completion_date">تاريخ إكمال الصيانة <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('completion_date') is-invalid @enderror" id="completion_date" name="completion_date" value="{{ old('completion_date', date('Y-m-d')) }}" required>
                                    @error('completion_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="actual_hours">الوقت الفعلي (بالساعات) <span class="text-danger">*</span></label>
                                    <input type="number" step="0.5" min="0.5" class="form-control @error('actual_hours') is-invalid @enderror" id="actual_hours" name="actual_hours" value="{{ old('actual_hours', $maintenance->estimated_hours) }}" required placeholder="أدخل الوقت الفعلي للصيانة">
                                    @error('actual_hours')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="actual_cost">التكلفة الفعلية <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" min="0" class="form-control @error('actual_cost') is-invalid @enderror" id="actual_cost" name="actual_cost" value="{{ old('actual_cost', $maintenance->cost) }}" required placeholder="أدخل التكلفة الفعلية للصيانة">
                                    @error('actual_cost')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="parts_cost">تكلفة قطع الغيار</label>
                                    <input type="number" step="0.01" min="0" class="form-control @error('parts_cost') is-invalid @enderror" id="parts_cost" name="parts_cost" value="{{ old('parts_cost', $maintenance->parts_cost) }}" placeholder="أدخل تكلفة قطع الغيار المستخدمة">
                                    @error('parts_cost')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="parts_used">قطع الغيار المستخدمة</label>
                            <select class="form-control select2 @error('parts_used') is-invalid @enderror" id="parts_used" name="parts_used[]" multiple>
                                @foreach($parts as $part)
                                    <option value="{{ $part->id }}" {{ (old('parts_used') && in_array($part->id, old('parts_used'))) || (is_null(old('parts_used')) && $maintenance->parts->contains($part->id)) ? 'selected' : '' }}>
                                        {{ $part->name }} ({{ $part->part_number ?? 'بدون رقم' }})
                                    </option>
                                @endforeach
                            </select>
                            @error('parts_used')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="completion_notes">ملاحظات الإكمال <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('completion_notes') is-invalid @enderror" id="completion_notes" name="completion_notes" rows="3" required placeholder="أدخل ملاحظات إكمال الصيانة">{{ old('completion_notes') }}</textarea>
                            @error('completion_notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="recommendations">التوصيات والإجراءات المستقبلية</label>
                            <textarea class="form-control @error('recommendations') is-invalid @enderror" id="recommendations" name="recommendations" rows="3" placeholder="أدخل التوصيات والإجراءات المستقبلية">{{ old('recommendations') }}</textarea>
                            @error('recommendations')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="attachments">إضافة مرفقات</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input @error('attachments') is-invalid @enderror" id="attachments" name="attachments[]" multiple>
                                    <label class="custom-file-label" for="attachments">اختر الملفات</label>
                                </div>
                            </div>
                            <small class="form-text text-muted">يمكنك تحميل صور أو مستندات متعلقة بالصيانة (الحد الأقصى: 5 ملفات، 2MB لكل ملف)</small>
                            @error('attachments')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="schedule_next_maintenance" name="schedule_next_maintenance" value="1" {{ old('schedule_next_maintenance') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="schedule_next_maintenance">جدولة الصيانة القادمة</label>
                            </div>
                        </div>
                        
                        <div class="form-group schedule-next-maintenance-fields" style="display: none;">
                            <label for="next_maintenance_date">تاريخ الصيانة القادمة</label>
                            <input type="date" class="form-control @error('next_maintenance_date') is-invalid @enderror" id="next_maintenance_date" name="next_maintenance_date" value="{{ old('next_maintenance_date', date('Y-m-d', strtotime('+3 months'))) }}">
                            @error('next_maintenance_date')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="notify_customer" name="notify_customer" value="1" {{ old('notify_customer', true) ? 'checked' : '' }}>
                                <label class="custom-control-label" for="notify_customer">إشعار العميل بإكمال الصيانة</label>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->

                    <div class="card-footer">
                        <button type="submit" class="btn btn-success">إكمال الصيانة</button>
                        <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-secondary">إلغاء</a>
                    </div>
                </form>
            </div>
            <!-- /.card -->
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function () {
        //Initialize Select2 Elements
        $('.select2').select2();
        
        // Custom file input
        bsCustomFileInput.init();
        
        // Toggle next maintenance fields
        $('#schedule_next_maintenance').change(function() {
            if(this.checked) {
                $('.schedule-next-maintenance-fields').show();
            } else {
                $('.schedule-next-maintenance-fields').hide();
            }
        });
        
        // Trigger on page load if checked
        if($('#schedule_next_maintenance').is(':checked')) {
            $('.schedule-next-maintenance-fields').show();
        }
    });
</script>
@endsection