@extends('layouts.app')

@section('title', 'إضافة قطع غيار للصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة قطع غيار لعملية الصيانة #{{ $maintenance->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للتفاصيل
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-ban"></i> خطأ!</h5>
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('elevator-maintenance.add-parts', $maintenance->id) }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card card-outline card-warning">
                                    <div class="card-header">
                                        <h3 class="card-title">قطع الغيار المستخدمة</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered" id="parts-table">
                                                <thead>
                                                    <tr>
                                                        <th>قطعة الغيار</th>
                                                        <th>الكمية</th>
                                                        <th>السعر</th>
                                                        <th>الإجمالي</th>
                                                        <th>إجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr id="part-row-0">
                                                        <td>
                                                            <select name="parts[0][part_id]" class="form-control select2 part-select" required>
                                                                <option value="">-- اختر قطعة غيار --</option>
                                                                @foreach($parts as $part)
                                                                    <option value="{{ $part->id }}" data-price="{{ $part->selling_price }}">
                                                                        {{ $part->name }} ({{ $part->part_number ?? 'بدون رقم' }}) - المخزون: {{ $part->current_stock }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <input type="number" name="parts[0][quantity]" class="form-control part-quantity" min="1" value="1" required>
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control part-price" readonly>
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control part-total" readonly>
                                                        </td>
                                                        <td>
                                                            <button type="button" class="btn btn-danger btn-sm remove-part" disabled>
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <td colspan="5">
                                                            <button type="button" class="btn btn-success btn-sm" id="add-part">
                                                                <i class="fas fa-plus"></i> إضافة قطعة غيار
                                                            </button>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th colspan="3" class="text-right">إجمالي تكلفة قطع الغيار:</th>
                                                        <th id="total-parts-cost">0</th>
                                                        <th></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ قطع الغيار
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function() {
        // Initialize Select2
        $('.select2').select2();
        
        // Add part row
        let rowIndex = 0;
        
        $('#add-part').click(function() {
            rowIndex++;
            let newRow = `
                <tr id="part-row-${rowIndex}">
                    <td>
                        <select name="parts[${rowIndex}][part_id]" class="form-control select2 part-select" required>
                            <option value="">-- اختر قطعة غيار --</option>
                            @foreach($parts as $part)
                                <option value="{{ $part->id }}" data-price="{{ $part->selling_price }}">
                                    {{ $part->name }} ({{ $part->part_number ?? 'بدون رقم' }}) - المخزون: {{ $part->current_stock }}
                                </option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <input type="number" name="parts[${rowIndex}][quantity]" class="form-control part-quantity" min="1" value="1" required>
                    </td>
                    <td>
                        <input type="text" class="form-control part-price" readonly>
                    </td>
                    <td>
                        <input type="text" class="form-control part-total" readonly>
                    </td>
                    <td>
                        <button type="button" class="btn btn-danger btn-sm remove-part">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
            `;
            
            $('#parts-table tbody').append(newRow);
            $('.select2').select2();
            
            // Bind events to the new row
            bindPartEvents();
        });
        
        // Remove part row
        $(document).on('click', '.remove-part', function() {
            $(this).closest('tr').remove();
            calculateTotalCost();
        });
        
        // Calculate part total when quantity or part changes
        function bindPartEvents() {
            $('.part-select').change(function() {
                let row = $(this).closest('tr');
                let price = $(this).find(':selected').data('price') || 0;
                let quantity = row.find('.part-quantity').val();
                
                row.find('.part-price').val(price);
                row.find('.part-total').val(price * quantity);
                
                calculateTotalCost();
            });
            
            $('.part-quantity').change(function() {
                let row = $(this).closest('tr');
                let price = row.find('.part-price').val() || 0;
                let quantity = $(this).val();
                
                row.find('.part-total').val(price * quantity);
                
                calculateTotalCost();
            });
        }
        
        // Calculate total cost of all parts
        function calculateTotalCost() {
            let total = 0;
            $('.part-total').each(function() {
                total += parseFloat($(this).val() || 0);
            });
            
            $('#total-parts-cost').text(total.toFixed(2));
        }
        
        // Initialize events
        bindPartEvents();
    });
</script>
@endsection