@extends('layouts.app')

@section('title', 'إضافة مرفقات للصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إضافة مرفقات لعملية الصيانة #{{ $maintenance->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('elevator-maintenance.show', $maintenance->id) }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للتفاصيل
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-ban"></i> خطأ!</h5>
                            {{ session('error') }}
                        </div>
                    @endif

                    <form action="{{ route('elevator-maintenance.add-attachments', $maintenance->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card card-outline card-info">
                                    <div class="card-header">
                                        <h3 class="card-title">المرفقات الجديدة</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="attachments">اختر الملفات</label>
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="attachments" name="attachments[]" multiple>
                                                    <label class="custom-file-label" for="attachments">اختر الملفات</label>
                                                </div>
                                            </div>
                                            <small class="form-text text-muted">يمكنك اختيار ملفات متعددة. الحد الأقصى لحجم الملف: 10MB</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="description">وصف المرفقات</label>
                                            <textarea class="form-control" id="description" name="description" rows="3" placeholder="وصف اختياري للمرفقات"></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-upload"></i> رفع المرفقات
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(function() {
        // Show file name when selected
        $(document).on('change', '.custom-file-input', function() {
            let fileCount = this.files.length;
            let label = $(this).next('.custom-file-label');
            
            if (fileCount > 1) {
                label.html(fileCount + ' ملفات مختارة');
            } else if (fileCount === 1) {
                let fileName = $(this).val().split('\\').pop();
                label.html(fileName);
            } else {
                label.html('اختر الملفات');
            }
        });
    });
</script>
@endsection